/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.VscConverterStation;
import java.util.Objects;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSetpointModification<T>
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSetpointModification.class);
    private final String elementId;
    private final Double voltageSetpoint;
    private final Double reactivePowerSetpoint;

    protected AbstractSetpointModification(String elementId, Double voltageSetpoint, Double reactivePowerSetpoint) {
        if (voltageSetpoint == null && reactivePowerSetpoint == null) {
            LOGGER.warn("Creating a {} modification with no modification", (Object)this.getElementName());
        }
        this.elementId = Objects.requireNonNull(elementId);
        this.voltageSetpoint = voltageSetpoint;
        this.reactivePowerSetpoint = reactivePowerSetpoint;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        T networkElement = this.getNetworkElement(network, this.elementId);
        if (networkElement == null) {
            ModificationLogs.logOrThrow(throwException, this.getElementName() + " '" + this.elementId + "' not found");
            return;
        }
        if (this.voltageSetpoint != null) {
            this.setVoltageSetpoint(networkElement, this.voltageSetpoint);
        }
        if (this.reactivePowerSetpoint != null) {
            this.setReactivePowerSetpoint(networkElement, this.reactivePowerSetpoint);
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        block3: {
            block6: {
                T networkElement;
                block7: {
                    block4: {
                        block5: {
                            block2: {
                                this.impact = DEFAULT_IMPACT;
                                networkElement = this.getNetworkElement(network, this.elementId);
                                if (networkElement != null) break block2;
                                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
                                break block3;
                            }
                            if (this.voltageSetpoint == null) break block4;
                            if (!(networkElement instanceof StaticVarCompensator)) break block5;
                            StaticVarCompensator staticVarCompensator = (StaticVarCompensator)networkElement;
                            if (Math.abs(this.voltageSetpoint - staticVarCompensator.getVoltageSetpoint()) < 1.0E-10) break block4;
                        }
                        if (!(networkElement instanceof VscConverterStation)) break block3;
                        VscConverterStation vscConverterStation = (VscConverterStation)networkElement;
                        if (!(Math.abs(this.voltageSetpoint - vscConverterStation.getVoltageSetpoint()) < 1.0E-10)) break block3;
                    }
                    if (this.reactivePowerSetpoint == null) break block6;
                    if (!(networkElement instanceof StaticVarCompensator)) break block7;
                    StaticVarCompensator staticVarCompensator = (StaticVarCompensator)networkElement;
                    if (Math.abs(this.reactivePowerSetpoint - staticVarCompensator.getReactivePowerSetpoint()) < 1.0E-10) break block6;
                }
                if (!(networkElement instanceof VscConverterStation)) break block3;
                VscConverterStation vscConverterStation = (VscConverterStation)networkElement;
                if (!(Math.abs(this.reactivePowerSetpoint - vscConverterStation.getReactivePowerSetpoint()) < 1.0E-10)) break block3;
            }
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    public abstract String getElementName();

    protected abstract void setVoltageSetpoint(T var1, Double var2);

    protected abstract void setReactivePowerSetpoint(T var1, Double var2);

    public abstract T getNetworkElement(Network var1, String var2);

    protected String getElementId() {
        return this.elementId;
    }

    public Double getReactivePowerSetpoint() {
        return this.reactivePowerSetpoint;
    }

    public OptionalDouble getOptionalReactivePowerSetpoint() {
        return this.reactivePowerSetpoint == null ? OptionalDouble.empty() : OptionalDouble.of(this.reactivePowerSetpoint);
    }

    public Double getVoltageSetpoint() {
        return this.voltageSetpoint;
    }

    public OptionalDouble getOptionalVoltageSetpoint() {
        return this.voltageSetpoint == null ? OptionalDouble.empty() : OptionalDouble.of(this.voltageSetpoint);
    }
}

