/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class AreaInterchangeTargetModification
extends AbstractNetworkModification {
    private final String areaId;
    private final double interchangeTarget;

    public AreaInterchangeTargetModification(String areadId, double interchangeTarget) {
        this.areaId = Objects.requireNonNull(areadId);
        this.interchangeTarget = interchangeTarget;
    }

    @Override
    public String getName() {
        return "AreaInterchangeModification";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Area area = network.getArea(this.areaId);
        if (area == null) {
            ModificationLogs.logOrThrow(throwException, "Area '" + this.areaId + "' not found");
            return;
        }
        area.setInterchangeTarget(this.interchangeTarget);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Area area = network.getArea(this.areaId);
        if (area == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (area.getInterchangeTarget().isPresent() && Math.abs(this.interchangeTarget - area.getInterchangeTarget().getAsDouble()) < 1.0E-10 || area.getInterchangeTarget().isEmpty() && Double.isNaN(this.interchangeTarget)) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public Double getInterchangeTarget() {
        return this.interchangeTarget;
    }
}

