/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.VoltageRegulationUtils;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;

public final class ConnectGenerator
extends AbstractNetworkModification {
    private final String generatorId;

    public ConnectGenerator(String generatorId) {
        this.generatorId = generatorId;
    }

    @Override
    public String getName() {
        return "ConnectGenerator";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Generator g = network.getGenerator(this.generatorId);
        if (g == null) {
            ModificationLogs.logOrThrow(throwException, "Generator '" + this.generatorId + "' not found");
        } else {
            ConnectGenerator.connect(g);
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Generator g = network.getGenerator(this.generatorId);
        if (g == null || g.getTerminal() == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (g.getTerminal().isConnected()) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    static void connect(Generator g) {
        Objects.requireNonNull(g);
        if (g.getTerminal().isConnected()) {
            return;
        }
        Terminal t = g.getTerminal();
        t.connect();
        if (g.isVoltageRegulatorOn()) {
            VoltageRegulationUtils.getTargetVForRegulatingElement(g.getNetwork(), g.getRegulatingTerminal().getBusView().getBus(), g.getId(), IdentifiableType.GENERATOR).ifPresent(arg_0 -> ((Generator)g).setTargetV(arg_0));
        }
    }
}

