/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.HvdcAngleDroopActivePowerControl;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HvdcLineModification
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(HvdcLineModification.class);
    private final String hvdcId;
    private final Boolean acEmulationEnabled;
    private final Double activePowerSetpoint;
    private final HvdcLine.ConvertersMode converterMode;
    private final Double droop;
    private final Double p0;
    private final Boolean relativeValue;

    public HvdcLineModification(String hvdcId, Boolean acEmulationEnabled, Double activePowerSetpoint, HvdcLine.ConvertersMode converterMode, Double droop, Double p0, Boolean relativeValue) {
        this.hvdcId = Objects.requireNonNull(hvdcId);
        this.acEmulationEnabled = acEmulationEnabled;
        this.activePowerSetpoint = activePowerSetpoint;
        this.converterMode = converterMode;
        this.droop = droop;
        this.p0 = p0;
        this.relativeValue = relativeValue;
    }

    @Override
    public String getName() {
        return "HvdcLineModification";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        HvdcLine hvdcLine = network.getHvdcLine(this.hvdcId);
        if (hvdcLine == null) {
            ModificationLogs.logOrThrow(throwException, "HvdcLine '" + this.hvdcId + "' not found");
            return;
        }
        if (this.activePowerSetpoint != null) {
            double newActivePowerSetpoint = this.activePowerSetpoint;
            if (this.relativeValue != null && this.relativeValue.booleanValue()) {
                newActivePowerSetpoint = hvdcLine.getActivePowerSetpoint() + this.activePowerSetpoint;
            }
            hvdcLine.setActivePowerSetpoint(newActivePowerSetpoint);
        } else if (this.relativeValue != null && this.relativeValue.booleanValue()) {
            LOG.warn("Relative value is set to true but it will not be applied since active power setpoint is undefined (null)");
        }
        if (this.converterMode != null) {
            hvdcLine.setConvertersMode(this.converterMode);
        }
        this.applyToHvdcAngleDroopActivePowerControlExtension(hvdcLine);
    }

    private void applyToHvdcAngleDroopActivePowerControlExtension(HvdcLine hvdcLine) {
        HvdcAngleDroopActivePowerControl hvdcAngleDroopActivePowerControl = (HvdcAngleDroopActivePowerControl)hvdcLine.getExtension(HvdcAngleDroopActivePowerControl.class);
        if (this.acEmulationEnabled != null) {
            if (hvdcAngleDroopActivePowerControl != null) {
                hvdcAngleDroopActivePowerControl.setEnabled(this.acEmulationEnabled.booleanValue());
            } else {
                LOG.warn("AV emulation enable is define with value {}, but it will not be apply since the hvdc line {} do not have a HvdcAngleDroopActivePowerControl extension", (Object)this.acEmulationEnabled, (Object)this.hvdcId);
            }
        }
        if (this.p0 != null) {
            if (hvdcAngleDroopActivePowerControl != null) {
                hvdcAngleDroopActivePowerControl.setP0(this.p0.floatValue());
            } else {
                LOG.warn("P0 is define with value {}, but it will not be apply since the hvdc line {} do not have a HvdcAngleDroopActivePowerControl extension", (Object)this.p0, (Object)this.hvdcId);
            }
        }
        if (this.droop != null) {
            if (hvdcAngleDroopActivePowerControl != null) {
                hvdcAngleDroopActivePowerControl.setDroop(this.droop.floatValue());
            } else {
                LOG.warn("Droop is define with value {}, but it will not be apply since the hvdc line {} do not have a HvdcAngleDroopActivePowerControl extension", (Object)this.droop, (Object)this.hvdcId);
            }
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        HvdcLine hvdcLine = network.getHvdcLine(this.hvdcId);
        if (hvdcLine == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else {
            HvdcAngleDroopActivePowerControl hvdcAngleDroopActivePowerControl = (HvdcAngleDroopActivePowerControl)hvdcLine.getExtension(HvdcAngleDroopActivePowerControl.class);
            if (this.areValuesEqual(this.activePowerSetpoint, hvdcLine.getActivePowerSetpoint(), this.relativeValue != null && this.relativeValue != false) && (this.converterMode == null || this.converterMode == hvdcLine.getConvertersMode()) && (hvdcAngleDroopActivePowerControl == null || (this.acEmulationEnabled == null || this.acEmulationEnabled.booleanValue() == hvdcAngleDroopActivePowerControl.isEnabled()) && this.areValuesEqual(this.p0, hvdcAngleDroopActivePowerControl.getP0(), false) && this.areValuesEqual(this.droop, hvdcAngleDroopActivePowerControl.getDroop(), false))) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        }
        return this.impact;
    }
}

