/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.modification.scalable.Scalable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ScalingParameters {
    public static final String VERSION = "1.2";
    public static final Scalable.ScalingConvention DEFAULT_SCALING_CONVENTION = Scalable.ScalingConvention.GENERATOR;
    public static final boolean DEFAULT_CONSTANT_POWER_FACTOR = false;
    public static final boolean DEFAULT_RECONNECT = false;
    public static final boolean DEFAULT_ALLOWS_GENERATOR_OUT_OF_ACTIVE_POWER_LIMITS = false;
    public static final Priority DEFAULT_PRIORITY = Priority.ONESHOT;
    public static final ScalingType DEFAULT_SCALING_TYPE = ScalingType.DELTA_P;
    public static final Set<String> DEFAULT_IGNORED_INJECTION_IDS = Collections.emptySet();
    private Scalable.ScalingConvention scalingConvention = DEFAULT_SCALING_CONVENTION;
    private boolean reconnect = false;
    private boolean constantPowerFactor = false;
    private boolean allowsGeneratorOutOfActivePowerLimits = false;
    private ScalingType scalingType = DEFAULT_SCALING_TYPE;
    private Priority priority = DEFAULT_PRIORITY;
    private Set<String> ignoredInjectionIds = DEFAULT_IGNORED_INJECTION_IDS;

    public ScalingParameters() {
    }

    @Deprecated(since="v6.0.0")
    public ScalingParameters(Scalable.ScalingConvention scalingConvention, boolean reconnect, boolean constantPowerFactor, boolean iterative, boolean allowsGeneratorOutOfActivePowerLimits) {
        this.scalingConvention = scalingConvention;
        this.reconnect = reconnect;
        this.constantPowerFactor = constantPowerFactor;
        this.priority = iterative ? Priority.RESPECT_OF_VOLUME_ASKED : Priority.ONESHOT;
        this.allowsGeneratorOutOfActivePowerLimits = allowsGeneratorOutOfActivePowerLimits;
    }

    public ScalingParameters(Scalable.ScalingConvention scalingConvention, boolean reconnect, boolean constantPowerFactor, Priority priority, boolean allowsGeneratorOutOfActivePowerLimits) {
        this.scalingConvention = scalingConvention;
        this.reconnect = reconnect;
        this.constantPowerFactor = constantPowerFactor;
        this.priority = priority;
        this.allowsGeneratorOutOfActivePowerLimits = allowsGeneratorOutOfActivePowerLimits;
    }

    public ScalingParameters(Scalable.ScalingConvention scalingConvention, boolean reconnect, boolean constantPowerFactor, Priority priority, boolean allowsGeneratorOutOfActivePowerLimits, ScalingType scalingType) {
        this.scalingConvention = scalingConvention;
        this.reconnect = reconnect;
        this.constantPowerFactor = constantPowerFactor;
        this.priority = priority;
        this.allowsGeneratorOutOfActivePowerLimits = allowsGeneratorOutOfActivePowerLimits;
        this.scalingType = scalingType;
    }

    public Scalable.ScalingConvention getScalingConvention() {
        return this.scalingConvention;
    }

    public ScalingParameters setScalingConvention(Scalable.ScalingConvention scalingConvention) {
        this.scalingConvention = scalingConvention;
        return this;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public ScalingParameters setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return this;
    }

    public boolean isConstantPowerFactor() {
        return this.constantPowerFactor;
    }

    public ScalingParameters setConstantPowerFactor(boolean constantPowerFactor) {
        this.constantPowerFactor = constantPowerFactor;
        return this;
    }

    @Deprecated(since="v6.0.0")
    public boolean isIterative() {
        return this.priority == Priority.RESPECT_OF_VOLUME_ASKED;
    }

    @Deprecated(since="v6.0.0")
    public ScalingParameters setIterative(boolean iterative) {
        return iterative ? this.setPriority(Priority.RESPECT_OF_VOLUME_ASKED) : this.setPriority(Priority.ONESHOT);
    }

    public boolean isAllowsGeneratorOutOfActivePowerLimits() {
        return this.allowsGeneratorOutOfActivePowerLimits;
    }

    public ScalingParameters setAllowsGeneratorOutOfActivePowerLimits(boolean allowsGeneratorOutOfActivePowerLimits) {
        this.allowsGeneratorOutOfActivePowerLimits = allowsGeneratorOutOfActivePowerLimits;
        return this;
    }

    public ScalingType getScalingType() {
        return this.scalingType;
    }

    public ScalingParameters setScalingType(ScalingType scalingType) {
        this.scalingType = scalingType;
        return this;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public ScalingParameters setPriority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public Set<String> getIgnoredInjectionIds() {
        return this.ignoredInjectionIds;
    }

    public ScalingParameters setIgnoredInjectionIds(Set<String> ignoredInjectionIds) {
        this.ignoredInjectionIds = new HashSet<String>(ignoredInjectionIds);
        return this;
    }

    public static ScalingParameters load() {
        return ScalingParameters.load(PlatformConfig.defaultConfig());
    }

    public static ScalingParameters load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        ScalingParameters scalingParameters = new ScalingParameters();
        platformConfig.getOptionalModuleConfig("scaling-default-parameters").ifPresent(config -> {
            scalingParameters.setScalingConvention((Scalable.ScalingConvention)config.getEnumProperty("scalingConvention", Scalable.ScalingConvention.class, (Enum)DEFAULT_SCALING_CONVENTION));
            scalingParameters.setConstantPowerFactor(config.getBooleanProperty("constantPowerFactor", false));
            scalingParameters.setReconnect(config.getBooleanProperty("reconnect", false));
            scalingParameters.setPriority((Priority)config.getEnumProperty("priority", Priority.class, (Enum)DEFAULT_PRIORITY));
            scalingParameters.setAllowsGeneratorOutOfActivePowerLimits(config.getBooleanProperty("allowsGeneratorOutOfActivePowerLimits", false));
            scalingParameters.setIgnoredInjectionIds(config.getOptionalStringListProperty("ignoredInjectionIds").map(list -> new HashSet(list)).orElse(DEFAULT_IGNORED_INJECTION_IDS));
        });
        return scalingParameters;
    }

    public static enum ScalingType {
        DELTA_P,
        TARGET_P;

    }

    public static enum Priority {
        RESPECT_OF_VOLUME_ASKED,
        RESPECT_OF_DISTRIBUTION,
        ONESHOT;

    }
}

