/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.modification.scalable.json.ScalingParametersDeserializer;
import com.powsybl.iidm.modification.scalable.json.ScalingParametersJsonModule;
import com.powsybl.iidm.modification.scalable.json.ScalingParametersSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public final class JsonScalingParameters {
    private JsonScalingParameters() {
    }

    public static ScalingParameters read(Path jsonFile) {
        return JsonScalingParameters.update(new ScalingParameters(), jsonFile);
    }

    public static ScalingParameters read(InputStream jsonStream) {
        return JsonScalingParameters.update(new ScalingParameters(), jsonStream);
    }

    public static ScalingParameters update(ScalingParameters parameters, Path jsonFile) {
        ScalingParameters scalingParameters;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                scalingParameters = JsonScalingParameters.update(parameters, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return scalingParameters;
    }

    public static ScalingParameters update(ScalingParameters parameters, InputStream jsonStream) {
        try {
            ObjectMapper objectMapper = JsonScalingParameters.createObjectMapper();
            return (ScalingParameters)objectMapper.readerForUpdating((Object)parameters).readValue(jsonStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(ScalingParameters parameters, Path jsonFile) {
        Objects.requireNonNull(jsonFile);
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            JsonScalingParameters.write(parameters, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(ScalingParameters parameters, OutputStream outputStream) {
        try {
            ObjectMapper objectMapper = JsonScalingParameters.createObjectMapper();
            ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
            writer.writeValue(outputStream, (Object)parameters);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new ScalingParametersJsonModule());
    }

    public static ScalingParameters deserialize(JsonParser parser, DeserializationContext deserializationContext, ScalingParameters scalingParameters) throws IOException {
        return new ScalingParametersDeserializer().deserialize(parser, deserializationContext, scalingParameters);
    }

    public static ScalingParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return new ScalingParametersDeserializer().deserialize(parser, deserializationContext);
    }

    public static void serialize(ScalingParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        new ScalingParametersSerializer().serialize(parameters, jsonGenerator, serializerProvider);
    }
}

