/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import java.io.IOException;

public class ScalingParametersSerializer
extends StdSerializer<ScalingParameters> {
    ScalingParametersSerializer() {
        super(ScalingParameters.class);
    }

    public void serialize(ScalingParameters scalingParameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", "1.2");
        jsonGenerator.writeStringField("scalingConvention", scalingParameters.getScalingConvention().name());
        jsonGenerator.writeBooleanField("constantPowerFactor", scalingParameters.isConstantPowerFactor());
        jsonGenerator.writeBooleanField("reconnect", scalingParameters.isReconnect());
        jsonGenerator.writeStringField("priority", scalingParameters.getPriority().name());
        jsonGenerator.writeArrayFieldStart("ignoredInjectionIds");
        for (String id : scalingParameters.getIgnoredInjectionIds().stream().sorted().toList()) {
            jsonGenerator.writeString(id);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

