/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.iidm.network.extensions.BusbarSectionPositionAdder;
import com.powsybl.math.graph.TraverseResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class CreateVoltageLevelSections
extends AbstractNetworkModification {
    private final String referenceBusbarSectionId;
    private final boolean createTheBusbarSectionsAfterTheReferenceBusbarSection;
    private final boolean createOnAllParallelBusbars;
    private final SwitchKind leftSwitchKind;
    private final SwitchKind rightSwitchKind;
    private final boolean leftSwitchFictitious;
    private final boolean rightSwitchFictitious;
    private final String switchPrefixId;
    private final String busbarSectionPrefixId;

    CreateVoltageLevelSections(String referenceBusbarSectionId, boolean createTheBusbarSectionsAfterTheReferenceBusbarSection, boolean createOnAllParallelBusbars, SwitchParameters leftSwitchParameters, SwitchParameters rightSwitchParameters, String switchPrefixId, String busbarSectionPrefixId) {
        this.referenceBusbarSectionId = Objects.requireNonNull(referenceBusbarSectionId, "Reference busbar section id not defined");
        this.createTheBusbarSectionsAfterTheReferenceBusbarSection = createTheBusbarSectionsAfterTheReferenceBusbarSection;
        this.createOnAllParallelBusbars = createOnAllParallelBusbars;
        this.leftSwitchKind = leftSwitchParameters.switchKind;
        this.rightSwitchKind = rightSwitchParameters.switchKind;
        this.leftSwitchFictitious = leftSwitchParameters.fictitious;
        this.rightSwitchFictitious = rightSwitchParameters.fictitious;
        this.switchPrefixId = Objects.requireNonNull(switchPrefixId, "Undefined switch prefix ID");
        this.busbarSectionPrefixId = Objects.requireNonNull(busbarSectionPrefixId, "Undefined busbar section prefix ID");
    }

    @Override
    public String getName() {
        return "CreateVoltageLevelSections";
    }

    public String getReferenceBusbarSectionId() {
        return this.referenceBusbarSectionId;
    }

    public boolean isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() {
        return this.createTheBusbarSectionsAfterTheReferenceBusbarSection;
    }

    public boolean isCreateOnAllParallelBusbars() {
        return this.createOnAllParallelBusbars;
    }

    public SwitchKind getLeftSwitchKind() {
        return this.leftSwitchKind;
    }

    public SwitchKind getRightSwitchKind() {
        return this.rightSwitchKind;
    }

    public boolean isLeftSwitchFictitious() {
        return this.leftSwitchFictitious;
    }

    public boolean isRightSwitchFictitious() {
        return this.rightSwitchFictitious;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        BusbarSection referenceBusbarSection = network.getBusbarSection(this.getReferenceBusbarSectionId());
        if (referenceBusbarSection == null) {
            ModificationLogs.busbarSectionDoesNotExist(this.getReferenceBusbarSectionId(), reportNode, throwException);
            return;
        }
        VoltageLevel voltageLevel = referenceBusbarSection.getTerminal().getVoltageLevel();
        if (voltageLevel == null) {
            return;
        }
        boolean allBusbarSectionsWithExtension = voltageLevel.getNodeBreakerView().getBusbarSectionStream().allMatch(busbarSection -> Objects.nonNull(busbarSection.getExtension(BusbarSectionPosition.class)));
        if (!allBusbarSectionsWithExtension) {
            ModificationReports.busbarSectionsWithoutPositionReport(reportNode, voltageLevel.getId());
            ModificationLogs.logOrThrow(throwException, String.format("Some busbar sections have no position in voltage level (%s)", voltageLevel.getId()));
            return;
        }
        BusbarSectionPosition referenceBusbarSectionPosition = (BusbarSectionPosition)referenceBusbarSection.getExtension(BusbarSectionPosition.class);
        List<BusbarSection> busbarSections = !this.isCreateOnAllParallelBusbars() ? List.of(referenceBusbarSection) : TopologyModificationUtils.getParallelBusbarSections(voltageLevel, referenceBusbarSectionPosition);
        int nextSectionIndex = this.findNextSectionIndex(voltageLevel, referenceBusbarSectionPosition);
        SwitchKind switchKind1 = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? this.getLeftSwitchKind() : this.getRightSwitchKind();
        boolean switchFictitious1 = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? this.isLeftSwitchFictitious() : this.isRightSwitchFictitious();
        SwitchKind switchKind2 = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? this.getRightSwitchKind() : this.getLeftSwitchKind();
        boolean switchFictitious2 = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? this.isRightSwitchFictitious() : this.isLeftSwitchFictitious();
        busbarSections.forEach(busbarSection -> this.createSection(new CreateSectionParameters((BusbarSection)busbarSection, voltageLevel, nextSectionIndex, switchKind1, switchFictitious1, switchKind2, switchFictitious2, namingStrategy, reportNode, throwException)));
    }

    private void createSection(CreateSectionParameters createSectionParameters) {
        BusbarSection busbarSection = createSectionParameters.busbarSection;
        VoltageLevel voltageLevel = createSectionParameters.voltageLevel;
        int nextSectionIndex = createSectionParameters.nextSectionIndex;
        SwitchKind switchKind1 = createSectionParameters.switchKind1;
        boolean switchFictitious1 = createSectionParameters.switchFictitious1;
        SwitchKind switchKind2 = createSectionParameters.switchKind2;
        boolean switchFictitious2 = createSectionParameters.switchFictitious2;
        NamingStrategy namingStrategy = createSectionParameters.namingStrategy;
        ReportNode reportNode = createSectionParameters.reportNode;
        boolean throwException = createSectionParameters.throwException;
        BusbarSectionPosition busbarSectionPosition = (BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class);
        if (nextSectionIndex == -1) {
            BusbarSection newBusbarSection = this.createBusbarSection(voltageLevel, namingStrategy, busbarSectionPosition);
            this.createSwitchesBetweenBusbarSections(voltageLevel, busbarSection, newBusbarSection, namingStrategy, switchKind1, switchFictitious1);
        } else {
            BusbarSectionFinderTraverser traverser = new BusbarSectionFinderTraverser(busbarSection.getId(), busbarSectionPosition.getBusbarIndex(), nextSectionIndex);
            busbarSection.getTerminal().traverse((Terminal.TopologyTraverser)traverser);
            BusbarSection neighbourBusbarSection = traverser.getFoundBusbarSection();
            if (neighbourBusbarSection == null) {
                ModificationReports.failToInsertBusbarSectionReport(reportNode, voltageLevel.getId(), busbarSection.getId());
                String message = String.format("Can't insert a busbar section in voltage level (%s) before or after busbar section (%s) : no neighbour busbar section found to do the operation", voltageLevel.getId(), busbarSection.getId());
                ModificationLogs.logOrThrow(throwException, message);
                return;
            }
            List<Switch> switchesEncountered = traverser.getSwitchesEncountered();
            switchesEncountered.forEach(s -> voltageLevel.getNodeBreakerView().removeSwitch(s.getId()));
            BusbarSection newBusbarSection = this.createBusbarSection(voltageLevel, namingStrategy, busbarSectionPosition);
            this.createSwitchesBetweenBusbarSections(voltageLevel, busbarSection, newBusbarSection, namingStrategy, switchKind1, switchFictitious1);
            this.createSwitchesBetweenBusbarSections(voltageLevel, newBusbarSection, neighbourBusbarSection, namingStrategy, switchKind2, switchFictitious2);
        }
    }

    private int findNextSectionIndex(VoltageLevel vl, BusbarSectionPosition referenceBusbarSectionPosition) {
        boolean indexesShouldBeIncremented;
        int nextSectionIndex;
        int n = nextSectionIndex = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? this.getMinimalPositionAfter(vl, referenceBusbarSectionPosition.getSectionIndex()) : this.getMaximalPositionBefore(vl, referenceBusbarSectionPosition.getSectionIndex());
        boolean bl = nextSectionIndex == -1 ? !this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() && referenceBusbarSectionPosition.getSectionIndex() == 1 : (indexesShouldBeIncremented = Math.abs(referenceBusbarSectionPosition.getSectionIndex() - nextSectionIndex) == 1);
        if (indexesShouldBeIncremented) {
            this.incrementSectionIndexes(vl, referenceBusbarSectionPosition.getSectionIndex());
            if (this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection()) {
                ++nextSectionIndex;
            }
        }
        return nextSectionIndex;
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        BusbarSection busbarSection = network.getBusbarSection(this.getReferenceBusbarSectionId());
        if (!CreateVoltageLevelSections.checkVoltageLevel(busbarSection)) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private BusbarSection createBusbarSection(VoltageLevel vl, NamingStrategy namingStrategy, BusbarSectionPosition busbarSectionPosition) {
        int busbarSectionNode = vl.getNodeBreakerView().getMaximumNodeIndex() + 1;
        int sectionNum = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? busbarSectionPosition.getSectionIndex() + 1 : busbarSectionPosition.getSectionIndex() - 1;
        int busbarNum = busbarSectionPosition.getBusbarIndex();
        BusbarSection busbarSection = ((BusbarSectionAdder)((BusbarSectionAdder)vl.getNodeBreakerView().newBusbarSection().setId(namingStrategy.getBusbarId(this.busbarSectionPrefixId, busbarNum, sectionNum))).setName(Integer.toString(busbarSectionNode))).setNode(busbarSectionNode).add();
        ((BusbarSectionPositionAdder)busbarSection.newExtension(BusbarSectionPositionAdder.class)).withBusbarIndex(busbarNum).withSectionIndex(sectionNum).add();
        return busbarSection;
    }

    private int getMinimalPositionAfter(VoltageLevel vl, int referenceSectionIndex) {
        return vl.getNodeBreakerView().getBusbarSectionStream().filter(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex() > referenceSectionIndex).min(Comparator.comparing(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex())).map(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex()).orElse(-1);
    }

    private int getMaximalPositionBefore(VoltageLevel vl, int referenceSectionIndex) {
        return vl.getNodeBreakerView().getBusbarSectionStream().filter(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex() < referenceSectionIndex).max(Comparator.comparing(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex())).map(busbarSection -> ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex()).orElse(-1);
    }

    private void incrementSectionIndexes(VoltageLevel vl, int referenceSectionIndex) {
        vl.getNodeBreakerView().getBusbarSectionStream().forEach(busbarSection -> {
            int sIndexToCompare;
            int sIndex = ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).getSectionIndex();
            int n = sIndexToCompare = this.isCreateTheBusbarSectionsAfterTheReferenceBusbarSection() ? referenceSectionIndex + 1 : referenceSectionIndex;
            if (sIndex >= sIndexToCompare) {
                ((BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class)).setSectionIndex(sIndex + 1);
            }
        });
    }

    private void createSwitchesBetweenBusbarSections(VoltageLevel vl, BusbarSection busbarSection1, BusbarSection busbarSection2, NamingStrategy namingStrategy, SwitchKind switchKind, boolean fictitious) {
        int busbarSection1Node = busbarSection1.getTerminal().getNodeBreakerView().getNode();
        int busbarSection2Node = busbarSection2.getTerminal().getNodeBreakerView().getNode();
        int firstDisconnectorNode2 = switchKind == SwitchKind.BREAKER ? vl.getNodeBreakerView().getMaximumNodeIndex() + 1 : busbarSection2Node;
        int busbarNum = ((BusbarSectionPosition)busbarSection1.getExtension(BusbarSectionPosition.class)).getBusbarIndex();
        int busbarSection1Num = ((BusbarSectionPosition)busbarSection1.getExtension(BusbarSectionPosition.class)).getSectionIndex();
        int busbarSection2Num = ((BusbarSectionPosition)busbarSection2.getExtension(BusbarSectionPosition.class)).getSectionIndex();
        String chunkingPrefixId = namingStrategy.getChunkPrefix(this.switchPrefixId, List.of(switchKind), busbarNum, busbarSection1Num, busbarSection2Num);
        TopologyModificationUtils.createNBDisconnector(busbarSection1Node, firstDisconnectorNode2, namingStrategy.getDisconnectorBetweenChunksId(busbarSection1, chunkingPrefixId, busbarSection1Node, firstDisconnectorNode2), vl.getNodeBreakerView(), false, fictitious);
        if (switchKind == SwitchKind.BREAKER) {
            int breakerNode2 = vl.getNodeBreakerView().getMaximumNodeIndex() + 1;
            TopologyModificationUtils.createNBBreaker(firstDisconnectorNode2, breakerNode2, namingStrategy.getBreakerId(chunkingPrefixId, firstDisconnectorNode2, breakerNode2), vl.getNodeBreakerView(), false, fictitious);
            TopologyModificationUtils.createNBDisconnector(breakerNode2, busbarSection2Node, namingStrategy.getDisconnectorBetweenChunksId(busbarSection2, chunkingPrefixId, breakerNode2, busbarSection2Node), vl.getNodeBreakerView(), false, fictitious);
        }
    }

    record SwitchParameters(SwitchKind switchKind, boolean fictitious) {
    }

    private record CreateSectionParameters(BusbarSection busbarSection, VoltageLevel voltageLevel, int nextSectionIndex, SwitchKind switchKind1, boolean switchFictitious1, SwitchKind switchKind2, boolean switchFictitious2, NamingStrategy namingStrategy, ReportNode reportNode, boolean throwException) {
    }

    private static class BusbarSectionFinderTraverser
    implements Terminal.TopologyTraverser {
        private final String startingBusBarSectionId;
        private final int busbarIndex;
        private final int sectionIndex;
        private BusbarSection foundBusbarSection;
        private final List<Switch> switchesEncountered = new ArrayList<Switch>();

        public BusbarSectionFinderTraverser(String startingBusBarSectionId, int busbarIndex, int sectionIndex) {
            this.startingBusBarSectionId = startingBusBarSectionId;
            this.busbarIndex = busbarIndex;
            this.sectionIndex = sectionIndex;
        }

        public TraverseResult traverse(Terminal terminal, boolean connected) {
            if (terminal.getConnectable().getType() == IdentifiableType.BUSBAR_SECTION) {
                BusbarSection busbarSection = (BusbarSection)terminal.getConnectable();
                if (busbarSection.getId().equals(this.startingBusBarSectionId)) {
                    return TraverseResult.CONTINUE;
                }
                BusbarSectionPosition busbarSectionPosition = (BusbarSectionPosition)busbarSection.getExtension(BusbarSectionPosition.class);
                if (busbarSectionPosition != null) {
                    if (busbarSectionPosition.getBusbarIndex() == this.busbarIndex && busbarSectionPosition.getSectionIndex() == this.sectionIndex) {
                        this.foundBusbarSection = busbarSection;
                        return TraverseResult.TERMINATE_TRAVERSER;
                    }
                    this.switchesEncountered.clear();
                    return TraverseResult.TERMINATE_PATH;
                }
                this.switchesEncountered.clear();
                return TraverseResult.TERMINATE_PATH;
            }
            this.switchesEncountered.clear();
            return TraverseResult.TERMINATE_PATH;
        }

        public TraverseResult traverse(Switch aSwitch) {
            this.switchesEncountered.add(aSwitch);
            return TraverseResult.CONTINUE;
        }

        public BusbarSection getFoundBusbarSection() {
            return this.foundBusbarSection;
        }

        public List<Switch> getSwitchesEncountered() {
            return this.switchesEncountered;
        }
    }
}

