/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.iidm.modification.topology.CreateVoltageLevelTopology;
import com.powsybl.iidm.network.SwitchKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CreateVoltageLevelTopologyBuilder {
    private String voltageLevelId = null;
    private int lowBusOrBusbarIndex = 1;
    private Integer alignedBusesOrBusbarCount = null;
    private int lowSectionIndex = 1;
    private Integer sectionCount = null;
    private String busOrBusbarSectionPrefixId = null;
    private String switchPrefixId = null;
    private List<SwitchKind> switchKinds = Collections.emptyList();

    public CreateVoltageLevelTopologyBuilder withVoltageLevelId(String voltageLevelId) {
        this.voltageLevelId = voltageLevelId;
        if (this.busOrBusbarSectionPrefixId == null) {
            this.busOrBusbarSectionPrefixId = voltageLevelId;
        }
        if (this.switchPrefixId == null) {
            this.switchPrefixId = voltageLevelId;
        }
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withLowBusOrBusbarIndex(int lowBusOrBusbarIndex) {
        this.lowBusOrBusbarIndex = lowBusOrBusbarIndex;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withAlignedBusesOrBusbarCount(int alignedBusesOrBusbarCount) {
        this.alignedBusesOrBusbarCount = alignedBusesOrBusbarCount;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withLowSectionIndex(int lowSectionIndex) {
        this.lowSectionIndex = lowSectionIndex;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withSectionCount(int sectionCount) {
        this.sectionCount = sectionCount;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withBusbarSectionPrefixId(String busbarSectionPrefixId) {
        this.busOrBusbarSectionPrefixId = busbarSectionPrefixId;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withSwitchPrefixId(String switchPrefixId) {
        this.switchPrefixId = switchPrefixId;
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withSwitchKinds(SwitchKind ... switchKinds) {
        this.switchKinds = Arrays.asList(switchKinds);
        return this;
    }

    public CreateVoltageLevelTopologyBuilder withSwitchKinds(List<SwitchKind> switchKinds) {
        this.switchKinds = switchKinds != null ? new ArrayList<SwitchKind>(switchKinds) : null;
        return this;
    }

    public CreateVoltageLevelTopology build() {
        return new CreateVoltageLevelTopology(this.voltageLevelId, this.lowBusOrBusbarIndex, this.alignedBusesOrBusbarCount, this.lowSectionIndex, this.sectionCount, this.busOrBusbarSectionPrefixId, this.switchPrefixId, this.switchKinds);
    }
}

