/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.topology.AbstractLineDisconnectionModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.RemoveFeederBay;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceTeePointByVoltageLevelOnLine
extends AbstractLineDisconnectionModification<ReplaceTeePointByVoltageLevelOnLine> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceTeePointByVoltageLevelOnLine.class);
    private final String bbsOrBusId;
    private final String newLine1Id;
    private final String newLine1Name;
    private final String newLine2Id;
    private final String newLine2Name;
    private static final String LINE_NOT_FOUND_REPORT_MESSAGE = "Line %s is not found";
    private static final String LINE_REMOVED_LOG_MESSAGE = "Line {} removed";

    ReplaceTeePointByVoltageLevelOnLine(String teePointLine1Id, String teePointLine2Id, String teePointLineToRemoveId, String bbsOrBusId, String newLine1Id, String newLine1Name, String newLine2Id, String newLine2Name) {
        super(teePointLine1Id, teePointLine2Id, teePointLineToRemoveId);
        this.bbsOrBusId = Objects.requireNonNull(bbsOrBusId);
        this.newLine1Id = Objects.requireNonNull(newLine1Id);
        this.newLine1Name = newLine1Name;
        this.newLine2Id = Objects.requireNonNull(newLine2Id);
        this.newLine2Name = newLine2Name;
    }

    @Override
    public String getName() {
        return "ReplaceTeePointByVoltageLevelOnLine";
    }

    public String getTeePointLine1Id() {
        return this.oldLine1Id;
    }

    public String getTeePointLine2Id() {
        return this.oldLine2Id;
    }

    public String getTeePointLineToRemoveId() {
        return this.lineToRemoveId;
    }

    public String getBbsOrBusId() {
        return this.bbsOrBusId;
    }

    public String getNewLine1Id() {
        return this.newLine1Id;
    }

    public String getNewLine1Name() {
        return this.newLine1Name;
    }

    public String getNewLine2Id() {
        return this.newLine2Id;
    }

    public String getNewLine2Name() {
        return this.newLine2Name;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Line tpLine1 = this.getLineFromNetwork(network, this.oldLine1Id, reportNode, throwException);
        Line tpLine2 = this.getLineFromNetwork(network, this.oldLine2Id, reportNode, throwException);
        if (tpLine1 == null || tpLine2 == null) {
            return;
        }
        Line tpLineToRemove = this.getLineFromNetwork(network, this.lineToRemoveId, reportNode, throwException);
        if (tpLineToRemove == null) {
            return;
        }
        VoltageLevel teePoint = TopologyModificationUtils.findTeePoint(tpLine1, tpLine2, tpLineToRemove);
        if (teePoint == null) {
            ModificationReports.noTeePointAndOrTappedVoltageLevelReport(reportNode, this.oldLine1Id, this.oldLine2Id, this.lineToRemoveId);
            ModificationLogs.logOrThrow(throwException, String.format("Unable to find the tee point and the tapped voltage level from lines %s, %s and %s", this.oldLine1Id, this.oldLine2Id, this.lineToRemoveId));
            return;
        }
        VoltageLevel tappedVoltageLevel = tpLineToRemove.getTerminal1().getVoltageLevel() == teePoint ? tpLineToRemove.getTerminal2().getVoltageLevel() : tpLineToRemove.getTerminal1().getVoltageLevel();
        TwoSides tpLine1OtherVlSide = tpLine1.getTerminal1().getVoltageLevel() == teePoint ? TwoSides.TWO : TwoSides.ONE;
        TwoSides tpLine2OtherVlSide = tpLine2.getTerminal1().getVoltageLevel() == teePoint ? TwoSides.TWO : TwoSides.ONE;
        LineAdder newLine1Adder = TopologyModificationUtils.createLineAdder(this.newLine1Id, this.newLine1Name, tpLine1.getTerminal(tpLine1OtherVlSide).getVoltageLevel().getId(), tappedVoltageLevel.getId(), network, tpLine1, tpLineToRemove);
        LineAdder newLine2Adder = TopologyModificationUtils.createLineAdder(this.newLine2Id, this.newLine2Name, tappedVoltageLevel.getId(), tpLine2.getTerminal(tpLine2OtherVlSide).getVoltageLevel().getId(), network, tpLine2, tpLineToRemove);
        TopologyModificationUtils.attachLine(tpLine1.getTerminal(tpLine1OtherVlSide), newLine1Adder, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(tpLine2.getTerminal(tpLine2OtherVlSide), newLine2Adder, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        if (!this.createTopology(newLine1Adder, newLine2Adder, tappedVoltageLevel, namingStrategy, reportNode, throwException)) {
            return;
        }
        TwoSides tpLine1Limits1Side = tpLine1OtherVlSide;
        TwoSides tpLine1Limits2Side = tpLine1OtherVlSide == TwoSides.ONE ? TwoSides.TWO : TwoSides.ONE;
        TopologyModificationUtils.LoadingLimitsBags limits1TpLine1 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine1.getActivePowerLimits(tpLine1Limits1Side), () -> tpLine1.getApparentPowerLimits(tpLine1Limits1Side), () -> tpLine1.getCurrentLimits(tpLine1Limits1Side));
        TopologyModificationUtils.LoadingLimitsBags limits2TpLine1 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine1.getActivePowerLimits(tpLine1Limits2Side), () -> tpLine1.getApparentPowerLimits(tpLine1Limits2Side), () -> tpLine1.getCurrentLimits(tpLine1Limits2Side));
        TwoSides tpLine2Limits1Side = tpLine2OtherVlSide == TwoSides.ONE ? TwoSides.TWO : TwoSides.ONE;
        TwoSides tpLine2Limits2Side = tpLine2OtherVlSide;
        TopologyModificationUtils.LoadingLimitsBags limits1TpLine2 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine2.getActivePowerLimits(tpLine2Limits1Side), () -> tpLine2.getApparentPowerLimits(tpLine2Limits1Side), () -> tpLine2.getCurrentLimits(tpLine2Limits1Side));
        TopologyModificationUtils.LoadingLimitsBags limits2TpLine2 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine2.getActivePowerLimits(tpLine2Limits2Side), () -> tpLine2.getApparentPowerLimits(tpLine2Limits2Side), () -> tpLine2.getCurrentLimits(tpLine2Limits2Side));
        tpLine1.remove();
        ModificationReports.removedLineReport(reportNode, this.oldLine1Id);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.oldLine1Id);
        tpLine2.remove();
        ModificationReports.removedLineReport(reportNode, this.oldLine2Id);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.oldLine2Id);
        new RemoveFeederBay(tpLineToRemove.getId()).apply(network, namingStrategy, throwException, computationManager, reportNode);
        ModificationReports.removedLineReport(reportNode, this.lineToRemoveId);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.lineToRemoveId);
        Line newLine1 = newLine1Adder.add();
        TopologyModificationUtils.addLoadingLimits(newLine1, limits1TpLine1, TwoSides.ONE);
        TopologyModificationUtils.addLoadingLimits(newLine1, limits2TpLine1, TwoSides.TWO);
        ModificationReports.createdLineReport(reportNode, this.newLine1Id);
        LOGGER.info("Line {} created", (Object)this.newLine1Id);
        Line newLine2 = newLine2Adder.add();
        TopologyModificationUtils.addLoadingLimits(newLine2, limits1TpLine2, TwoSides.ONE);
        TopologyModificationUtils.addLoadingLimits(newLine2, limits2TpLine2, TwoSides.TWO);
        ModificationReports.createdLineReport(reportNode, this.newLine2Id);
        LOGGER.info("Line {} created", (Object)this.newLine2Id);
        TopologyModificationUtils.removeVoltageLevelAndSubstation(teePoint, reportNode);
    }

    private boolean createTopology(LineAdder newLine1Adder, LineAdder newLine2Adder, VoltageLevel tappedVoltageLevel, NamingStrategy namingStrategy, ReportNode reportNode, boolean throwException) {
        TopologyKind topologyKind = tappedVoltageLevel.getTopologyKind();
        if (topologyKind == TopologyKind.BUS_BREAKER) {
            Bus bus = tappedVoltageLevel.getBusBreakerView().getBus(this.bbsOrBusId);
            if (bus == null) {
                return this.errorWhenBusNull(reportNode, tappedVoltageLevel, throwException);
            }
            Bus bus1 = ((BusAdder)tappedVoltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusId(this.newLine1Id))).add();
            Bus bus2 = ((BusAdder)tappedVoltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusId(this.newLine2Id))).add();
            TopologyModificationUtils.createBusBreakerSwitch(bus1.getId(), bus.getId(), namingStrategy.getSwitchId(this.newLine1Id, 1), tappedVoltageLevel.getBusBreakerView());
            TopologyModificationUtils.createBusBreakerSwitch(bus.getId(), bus2.getId(), namingStrategy.getSwitchId(this.newLine2Id, 2), tappedVoltageLevel.getBusBreakerView());
            newLine1Adder.setBus2(bus1.getId());
            newLine1Adder.setConnectableBus2(bus1.getId());
            newLine2Adder.setBus1(bus2.getId());
            newLine2Adder.setConnectableBus1(bus2.getId());
        } else if (topologyKind == TopologyKind.NODE_BREAKER) {
            BusbarSection bbs = tappedVoltageLevel.getNodeBreakerView().getBusbarSection(this.bbsOrBusId);
            if (bbs == null) {
                return this.errorWhenBusbarSectionNull(reportNode, tappedVoltageLevel, throwException);
            }
            int firstAvailableNode = tappedVoltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
            newLine1Adder.setNode2(firstAvailableNode);
            newLine2Adder.setNode1(firstAvailableNode + 3);
            BusbarSectionPosition position = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
            if (position == null) {
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(tappedVoltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, this.newLine1Id, bbs);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(tappedVoltageLevel, firstAvailableNode + 3, firstAvailableNode + 2, namingStrategy, this.newLine2Id, bbs);
                LOGGER.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs.getId());
                ModificationReports.noBusbarSectionPositionExtensionReport(reportNode, bbs);
            } else {
                List<BusbarSection> bbsList = TopologyModificationUtils.getParallelBusbarSections(tappedVoltageLevel, position);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(tappedVoltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, this.newLine1Id, bbsList, bbs);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(tappedVoltageLevel, firstAvailableNode + 3, firstAvailableNode + 2, namingStrategy, this.newLine2Id, bbsList, bbs);
            }
        }
        return true;
    }

    private Line getLineFromNetwork(Network network, String lineId, ReportNode reportNode, boolean throwException) {
        Line line = network.getLine(lineId);
        if (line == null) {
            ModificationReports.notFoundLineReport(reportNode, lineId);
            ModificationLogs.logOrThrow(throwException, String.format(LINE_NOT_FOUND_REPORT_MESSAGE, lineId));
            return null;
        }
        return line;
    }

    private boolean errorWhenBusNull(ReportNode reportNode, VoltageLevel voltageLevel, boolean throwException) {
        ModificationReports.notFoundBusInVoltageLevelReport(reportNode, this.bbsOrBusId, voltageLevel.getId());
        ModificationLogs.logOrThrow(throwException, String.format("Bus %s is not found in voltage level %s", this.bbsOrBusId, voltageLevel.getId()));
        return false;
    }

    private boolean errorWhenBusbarSectionNull(ReportNode reportNode, VoltageLevel voltageLevel, boolean throwException) {
        ModificationReports.notFoundBusbarSectionInVoltageLevelReport(reportNode, this.bbsOrBusId, voltageLevel.getId());
        ModificationLogs.logOrThrow(throwException, String.format("Busbar section %s is not found in voltage level %s", this.bbsOrBusId, voltageLevel.getId()));
        return false;
    }
}

