/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TieLine;
import java.util.Objects;

public abstract class AbstractConnectDisconnectModification
extends AbstractNetworkModification {
    final String identifiableId;
    ThreeSides side;
    final boolean isConnecting;

    AbstractConnectDisconnectModification(String identifiableId, ThreeSides side, boolean isConnecting) {
        this.identifiableId = Objects.requireNonNull(identifiableId);
        this.side = side;
        this.isConnecting = isConnecting;
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        HvdcLine hvdcLine;
        TieLine tieLine;
        Connectable connectable;
        this.impact = DEFAULT_IMPACT;
        Identifiable identifiable = network.getIdentifiable(this.identifiableId);
        if (this.checkIfCannotBeAppliedOnNetwork(identifiable)) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (identifiable instanceof Connectable && this.checkIfNoImpactOnNetwork(connectable = (Connectable)identifiable) || identifiable instanceof TieLine && this.checkIfNoImpactOnNetwork(tieLine = (TieLine)identifiable) || identifiable instanceof HvdcLine && this.checkIfNoImpactOnNetwork(hvdcLine = (HvdcLine)identifiable)) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkIfCannotBeAppliedOnNetwork(Identifiable<?> identifiable) {
        if (!(identifiable instanceof Connectable) && !(identifiable instanceof TieLine)) {
            if (!(identifiable instanceof HvdcLine)) return true;
        }
        if (identifiable instanceof Connectable) {
            Connectable connectable = (Connectable)identifiable;
            if (this.side == ThreeSides.TWO) {
                if (connectable.getTerminals().size() < 2) return true;
            }
            if (this.side == ThreeSides.THREE) {
                if (connectable.getTerminals().size() < 3) return true;
            }
        }
        if (!(identifiable instanceof TieLine)) {
            if (!(identifiable instanceof HvdcLine)) return false;
        }
        if (this.side != ThreeSides.THREE) return false;
        return true;
    }

    private boolean checkIfNoImpactOnNetwork(Connectable<?> connectable) {
        return this.side == null && connectable.getTerminals().stream().allMatch(terminal -> terminal.isConnected() == this.isConnecting) || this.side == ThreeSides.ONE && ((Terminal)connectable.getTerminals().get(0)).isConnected() == this.isConnecting || this.side == ThreeSides.TWO && ((Terminal)connectable.getTerminals().get(1)).isConnected() == this.isConnecting || this.side == ThreeSides.THREE && ((Terminal)connectable.getTerminals().get(2)).isConnected() == this.isConnecting;
    }

    private boolean checkIfNoImpactOnNetwork(TieLine tieLine) {
        return this.side == null && tieLine.getTerminal1().isConnected() == this.isConnecting && tieLine.getTerminal2().isConnected() == this.isConnecting || this.side != null && tieLine.getTerminal(this.side.toTwoSides()).isConnected() == this.isConnecting;
    }

    private boolean checkIfNoImpactOnNetwork(HvdcLine hvdcLine) {
        return this.side == null && hvdcLine.getConverterStation1().getTerminal().isConnected() == this.isConnecting && hvdcLine.getConverterStation2().getTerminal().isConnected() == this.isConnecting || this.side == ThreeSides.ONE && hvdcLine.getConverterStation1().getTerminal().isConnected() == this.isConnecting || this.side == ThreeSides.TWO && hvdcLine.getConverterStation2().getTerminal().isConnected() == this.isConnecting;
    }
}

