/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataFormat;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.DefaultNamingStrategy;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.NetworkSerDe;

public abstract class AbstractNetworkModification
implements NetworkModification {
    protected static final NetworkModificationImpact DEFAULT_IMPACT = NetworkModificationImpact.HAS_IMPACT_ON_NETWORK;
    protected static final double EPSILON = 1.0E-10;
    protected NetworkModificationImpact impact;

    @Override
    public void apply(Network network) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), false, LocalComputationManager.getDefault(), ReportNode.NO_OP);
    }

    @Override
    public boolean apply(Network network, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), false, LocalComputationManager.getDefault(), ReportNode.NO_OP, dryRun);
    }

    @Override
    public void apply(Network network, ComputationManager computationManager) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), false, computationManager, ReportNode.NO_OP);
    }

    @Override
    public boolean apply(Network network, ComputationManager computationManager, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), false, computationManager, ReportNode.NO_OP, dryRun);
    }

    @Override
    public void apply(Network network, ComputationManager computationManager, ReportNode reportNode) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), false, computationManager, reportNode);
    }

    @Override
    public boolean apply(Network network, ComputationManager computationManager, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), false, computationManager, reportNode, dryRun);
    }

    @Override
    public void apply(Network network, ReportNode reportNode) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), false, LocalComputationManager.getDefault(), reportNode);
    }

    @Override
    public boolean apply(Network network, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), false, LocalComputationManager.getDefault(), reportNode, dryRun);
    }

    @Override
    public void apply(Network network, boolean throwException, ReportNode reportNode) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), throwException, LocalComputationManager.getDefault(), reportNode);
    }

    @Override
    public boolean apply(Network network, boolean throwException, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), throwException, LocalComputationManager.getDefault(), reportNode, dryRun);
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        this.apply(network, (NamingStrategy)new DefaultNamingStrategy(), throwException, computationManager, reportNode);
    }

    @Override
    public boolean apply(Network network, boolean throwException, ComputationManager computationManager, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, new DefaultNamingStrategy(), throwException, computationManager, reportNode, dryRun);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy) {
        this.apply(network, namingStrategy, false, LocalComputationManager.getDefault(), ReportNode.NO_OP);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, boolean dryRun) {
        return this.apply(network, namingStrategy, false, LocalComputationManager.getDefault(), ReportNode.NO_OP, dryRun);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, ComputationManager computationManager) {
        this.apply(network, namingStrategy, false, computationManager, ReportNode.NO_OP);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, ComputationManager computationManager, boolean dryRun) {
        return this.apply(network, namingStrategy, false, computationManager, ReportNode.NO_OP, dryRun);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, ComputationManager computationManager, ReportNode reportNode) {
        this.apply(network, namingStrategy, false, computationManager, reportNode);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, ComputationManager computationManager, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, namingStrategy, false, computationManager, reportNode, dryRun);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, ReportNode reportNode) {
        this.apply(network, namingStrategy, false, LocalComputationManager.getDefault(), reportNode);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, namingStrategy, false, LocalComputationManager.getDefault(), reportNode, dryRun);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ReportNode reportNode) {
        this.apply(network, namingStrategy, throwException, LocalComputationManager.getDefault(), reportNode);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, boolean throwException, ReportNode reportNode, boolean dryRun) {
        return this.apply(network, namingStrategy, throwException, LocalComputationManager.getDefault(), reportNode, dryRun);
    }

    @Override
    public boolean apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode, boolean dryRun) {
        if (dryRun) {
            ReportNode dryRunReportNode = ModificationReports.reportOnDryRunStart(reportNode, this.getName(), network.getNameOrId());
            try {
                Network dryRunNetwork = NetworkSerDe.copy((Network)network, (TreeDataFormat)TreeDataFormat.JSON);
                dryRunNetwork.setName(network.getNameOrId() + "_Dry-run");
                this.apply(dryRunNetwork, namingStrategy, true, computationManager, dryRunReportNode);
            }
            catch (PowsyblException powsyblException) {
                ModificationReports.reportOnInconclusiveDryRun(dryRunReportNode, powsyblException.getMessage(), this.getName(), network.getNameOrId());
                return false;
            }
            ModificationReports.dryRunReportNode(dryRunReportNode, this.getName(), network.getNameOrId());
        } else {
            this.apply(network, namingStrategy, throwException, computationManager, reportNode);
        }
        return true;
    }

    public abstract String getName();

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        return DEFAULT_IMPACT;
    }

    protected static boolean checkVoltageLevel(Identifiable<?> identifiable) {
        VoltageLevel vl;
        if (identifiable instanceof Bus) {
            Bus bus = (Bus)identifiable;
            vl = bus.getVoltageLevel();
        } else if (identifiable instanceof BusbarSection) {
            BusbarSection bbs = (BusbarSection)identifiable;
            vl = bbs.getTerminal().getVoltageLevel();
        } else {
            return false;
        }
        return vl != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean areValuesEqual(Double newValue, double currentValue, boolean isRelativeValue) {
        if (newValue == null) return true;
        double d = newValue;
        double d2 = isRelativeValue ? 0.0 : currentValue;
        if (!(Math.abs(d - d2) < 1.0E-10)) return false;
        return true;
    }

    protected boolean areValuesEqual(Integer newValue, int currentValue, boolean isRelativeValue) {
        return newValue == null || Math.abs(newValue - (isRelativeValue ? 0 : currentValue)) < 1;
    }

    protected boolean isValueOutsideRange(int newValue, int minValue, int maxValue) {
        return newValue < minValue || newValue > maxValue;
    }
}

