/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class BatteryModification
extends AbstractNetworkModification {
    private final String batteryId;
    private final Double targetQ;
    private final Double targetP;

    public BatteryModification(String batteryId, Double targetP, Double targetQ) {
        this.batteryId = Objects.requireNonNull(batteryId);
        this.targetP = targetP;
        this.targetQ = targetQ;
    }

    @Override
    public String getName() {
        return "BatteryModification";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Battery battery = network.getBattery(this.batteryId);
        if (battery == null) {
            ModificationLogs.logOrThrow(throwException, "Battery '" + this.batteryId + "' not found");
            return;
        }
        if (this.targetP != null) {
            battery.setTargetP(this.targetP.doubleValue());
        }
        if (this.targetQ != null) {
            battery.setTargetQ(this.targetQ.doubleValue());
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Battery battery = network.getBattery(this.batteryId);
        if (battery == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if ((this.targetP == null || Math.abs(this.targetP - battery.getTargetP()) < 1.0E-10) && (this.targetQ == null || Math.abs(this.targetQ - battery.getTargetQ()) < 1.0E-10)) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    public String getBatteryId() {
        return this.batteryId;
    }

    public Double getTargetP() {
        return this.targetP;
    }

    public Double getTargetQ() {
        return this.targetQ;
    }
}

