/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractConnectDisconnectModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.util.SwitchPredicates;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectableConnection
extends AbstractConnectDisconnectModification {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectableConnection.class);
    final Predicate<Switch> isTypeSwitchToOperate;

    ConnectableConnection(String connectableId, boolean openFictitiousSwitches, boolean operateOnlyBreakers, ThreeSides side) {
        super(connectableId, side, true);
        Predicate predicate = SwitchPredicates.IS_NON_NULL;
        if (!openFictitiousSwitches) {
            predicate = predicate.and(SwitchPredicates.IS_NONFICTIONAL);
        }
        if (operateOnlyBreakers) {
            predicate = predicate.and(SwitchPredicates.IS_BREAKER);
        }
        this.isTypeSwitchToOperate = predicate;
    }

    @Override
    public String getName() {
        return "ConnectableConnection";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Identifiable identifiable = network.getIdentifiable(this.identifiableId);
        network.getReportNodeContext().pushReportNode(reportNode);
        if (identifiable == null) {
            ModificationLogs.logOrThrow(throwException, "Identifiable '" + this.identifiableId + "' not found");
        } else {
            this.connectIdentifiable(identifiable, network, throwException, reportNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectIdentifiable(Identifiable<?> identifiable, Network network, boolean throwException, ReportNode reportNode) {
        boolean hasBeenConnected = false;
        try {
            if (identifiable instanceof Connectable) {
                Connectable connectable = (Connectable)identifiable;
                hasBeenConnected = connectable.connect(this.isTypeSwitchToOperate, this.side);
            } else if (identifiable instanceof TieLine) {
                TieLine tieLine = (TieLine)identifiable;
                hasBeenConnected = tieLine.connectDanglingLines(this.isTypeSwitchToOperate, this.side == null ? null : this.side.toTwoSides());
            } else if (identifiable instanceof HvdcLine) {
                HvdcLine hvdcLine = (HvdcLine)identifiable;
                hasBeenConnected = hvdcLine.connectConverterStations(this.isTypeSwitchToOperate, this.side == null ? null : this.side.toTwoSides());
            } else {
                ModificationLogs.logOrThrow(throwException, String.format("Connection not implemented for identifiable '%s'", this.identifiableId));
            }
        }
        finally {
            network.getReportNodeContext().popReportNode();
        }
        if (hasBeenConnected) {
            LOG.info("Connectable {} has been connected {}.", (Object)this.identifiableId, this.side == null ? "on each side" : "on side " + this.side.getNum());
        } else {
            LOG.info("Connectable {} has NOT been connected {}.", (Object)this.identifiableId, this.side == null ? "on each side" : "on side " + this.side.getNum());
        }
        ModificationReports.connectableConnectionReport(reportNode, identifiable, hasBeenConnected, this.side);
    }
}

