/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.LoadFlowBasedPhaseShifterOptimizerConfig;
import com.powsybl.iidm.modification.PhaseShifterOptimizer;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.loadflow.LoadFlow;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFlowBasedPhaseShifterOptimizer
implements PhaseShifterOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadFlowBasedPhaseShifterOptimizer.class);
    private final ComputationManager computationManager;
    private final LoadFlowBasedPhaseShifterOptimizerConfig config;

    public LoadFlowBasedPhaseShifterOptimizer(ComputationManager computationManager, LoadFlowBasedPhaseShifterOptimizerConfig config) {
        this.computationManager = Objects.requireNonNull(computationManager);
        this.config = Objects.requireNonNull(config);
    }

    public LoadFlowBasedPhaseShifterOptimizer(ComputationManager computationManager) {
        this(computationManager, LoadFlowBasedPhaseShifterOptimizerConfig.load());
    }

    private void runLoadFlow(Network network, String workingStateId) {
        try {
            String loadFlowName = this.config.getLoadFlowName().orElse(null);
            LoadFlowResult result = LoadFlow.find((String)loadFlowName).run(network, workingStateId, this.computationManager, LoadFlowParameters.load());
            if (!result.isOk()) {
                throw new PowsyblException("Load flow diverged during phase shifter optimization");
            }
        }
        catch (Exception e) {
            throw new PowsyblException((Throwable)e);
        }
    }

    private static double getI(TwoWindingsTransformer phaseShifter) {
        return phaseShifter.getTerminal1().getI();
    }

    private static double getLimit(TwoWindingsTransformer phaseShifter) {
        return phaseShifter.getCurrentLimits1().map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findMaximalFlowTap(Network network, String phaseShifterId) {
        int optimalTap;
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(phaseShifterId);
        if (phaseShifter == null) {
            throw new PowsyblException("Phase shifter '" + phaseShifterId + "' not found");
        }
        if (!phaseShifter.hasPhaseTapChanger()) {
            throw new PowsyblException("Transformer '" + phaseShifterId + "' is not a phase shifter");
        }
        String stateId = network.getVariantManager().getWorkingVariantId();
        String tmpStateId = "phase-shifter-optim-" + String.valueOf(UUID.randomUUID());
        network.getVariantManager().cloneVariant(stateId, tmpStateId);
        try {
            double i;
            network.getVariantManager().setWorkingVariant(tmpStateId);
            this.runLoadFlow(network, tmpStateId);
            if (phaseShifter.getTerminal1().getI() >= phaseShifter.getCurrentLimits1().map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new)) {
                throw new PowsyblException("Phase shifter already overloaded");
            }
            int tapPosInc = 1;
            double limit = LoadFlowBasedPhaseShifterOptimizer.getLimit(phaseShifter);
            int tapPos = phaseShifter.getPhaseTapChanger().getTapPosition();
            int maxTap = phaseShifter.getPhaseTapChanger().getHighTapPosition();
            while (true) {
                double d;
                i = LoadFlowBasedPhaseShifterOptimizer.getI(phaseShifter);
                if (!(d < limit) || tapPos >= maxTap) break;
                phaseShifter.getPhaseTapChanger().setTapPosition(tapPos += tapPosInc);
                this.runLoadFlow(network, tmpStateId);
                if (!(LoadFlowBasedPhaseShifterOptimizer.getI(phaseShifter) < i)) continue;
                tapPosInc *= -1;
            }
            if (i < limit) {
                optimalTap = phaseShifter.getPhaseTapChanger().getTapPosition();
            } else {
                optimalTap = phaseShifter.getPhaseTapChanger().getTapPosition() - tapPosInc;
                phaseShifter.getPhaseTapChanger().setTapPosition(optimalTap);
                this.runLoadFlow(network, tmpStateId);
                if (LoadFlowBasedPhaseShifterOptimizer.getI(phaseShifter) >= limit) {
                    throw new IllegalStateException("Phase shifter should not be overload");
                }
            }
        }
        finally {
            network.getVariantManager().removeVariant(tmpStateId);
            network.getVariantManager().setWorkingVariant(stateId);
        }
        LOGGER.debug("Optimal phase shifter '{}' tap is {} (from {})", new Object[]{phaseShifter, optimalTap, phaseShifter.getPhaseTapChanger().getTapPosition()});
        phaseShifter.getPhaseTapChanger().setTapPosition(optimalTap);
    }
}

