/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.Network;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class NetworkModificationList
extends AbstractNetworkModification {
    private final List<NetworkModification> modificationList;

    public NetworkModificationList(List<NetworkModification> modificationList) {
        this.modificationList = Objects.requireNonNull(modificationList);
    }

    public NetworkModificationList(NetworkModification ... modificationList) {
        this(Arrays.asList(modificationList));
    }

    @Override
    public String getName() {
        return "NetworkModificationList";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        this.modificationList.forEach(modification -> modification.apply(network, namingStrategy, throwException, computationManager, reportNode));
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        Set unitaryImpacts = this.modificationList.stream().map(m -> m.hasImpactOnNetwork(network)).collect(Collectors.toSet());
        this.impact = unitaryImpacts.contains((Object)NetworkModificationImpact.CANNOT_BE_APPLIED) ? NetworkModificationImpact.CANNOT_BE_APPLIED : (unitaryImpacts.contains((Object)NetworkModificationImpact.HAS_IMPACT_ON_NETWORK) ? NetworkModificationImpact.HAS_IMPACT_ON_NETWORK : NetworkModificationImpact.NO_IMPACT_ON_NETWORK);
        return this.impact;
    }
}

