/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.modification.util.RegulatedTerminalControllers;
import com.powsybl.iidm.modification.util.TransformerUtils;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerToBeEstimatedAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerToBeEstimated;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replace3TwoWindingsTransformersByThreeWindingsTransformers
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(Replace3TwoWindingsTransformersByThreeWindingsTransformers.class);
    private static final String TWO_WINDINGS_TRANSFORMER = "TwoWindingsTransformer";
    private static final String WITH_FICTITIOUS_TERMINAL_USED_AS_REGULATED_TERMINAL = "with star terminal used as regulated terminal";
    private static final String CGMES_OPERATIONAL_LIMIT_SET = "CGMES.OperationalLimitSet_";
    private final List<String> transformersToBeReplaced;

    public Replace3TwoWindingsTransformersByThreeWindingsTransformers() {
        this.transformersToBeReplaced = null;
    }

    public Replace3TwoWindingsTransformersByThreeWindingsTransformers(List<String> transformersToBeReplaced) {
        this.transformersToBeReplaced = Objects.requireNonNull(transformersToBeReplaced);
    }

    @Override
    public String getName() {
        return "Replace3TwoWindingsTransformersByThreeWindingsTransformers";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        RegulatedTerminalControllers regulatedTerminalControllers = new RegulatedTerminalControllers(network);
        List<TwoR> twoWindingsTransformers = Replace3TwoWindingsTransformersByThreeWindingsTransformers.find3TwoWindingsTransformers(network, this.transformersToBeReplaced);
        twoWindingsTransformers.forEach(twoR -> this.replace3TwoWindingsTransformerByThreeWindingsTransformer((TwoR)twoR, regulatedTerminalControllers, throwException, reportNode));
    }

    private static List<TwoR> find3TwoWindingsTransformers(Network network, List<String> transformersToBeReplaced) {
        HashMap twoWindingTransformersByBus = new HashMap();
        network.getTwoWindingsTransformers().forEach(t2w -> {
            Bus bus1 = t2w.getTerminal1().getBusView().getBus();
            Bus bus2 = t2w.getTerminal2().getBusView().getBus();
            if (bus1 != null) {
                twoWindingTransformersByBus.computeIfAbsent(bus1, k -> new ArrayList()).add(new TransformerAndStarBusSide((TwoWindingsTransformer)t2w, TwoSides.ONE));
            }
            if (bus2 != null) {
                twoWindingTransformersByBus.computeIfAbsent(bus2, k -> new ArrayList()).add(new TransformerAndStarBusSide((TwoWindingsTransformer)t2w, TwoSides.TWO));
            }
        });
        return twoWindingTransformersByBus.keySet().stream().filter(bus -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.isStarBus(bus, (List)twoWindingTransformersByBus.get(bus))).sorted(Comparator.comparing(Identifiable::getId)).map(bus -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.buildTwoR(bus, (List)twoWindingTransformersByBus.get(bus))).filter(twoR -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.isGoingToBeReplaced(twoR, transformersToBeReplaced)).toList();
    }

    private static boolean isGoingToBeReplaced(TwoR twoR, List<String> transformersToBeReplaced) {
        return transformersToBeReplaced == null || transformersToBeReplaced.contains(twoR.t2w1.getId()) || transformersToBeReplaced.contains(twoR.t2w2.getId()) || transformersToBeReplaced.contains(twoR.t2w3.getId());
    }

    private static boolean isStarBus(Bus bus, List<TransformerAndStarBusSide> t2ws) {
        return t2ws.size() == 3 && bus.getConnectedTerminalStream().filter(connectedTerminal -> connectedTerminal.getConnectable().getType() != IdentifiableType.BUSBAR_SECTION).count() == 3L;
    }

    private static TwoR buildTwoR(Bus starBus, List<TransformerAndStarBusSide> starBusT2ws) {
        List<TransformerAndStarBusSide> sortedStarBusT2ws = starBusT2ws.stream().sorted(Comparator.comparingDouble(t2w -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.getNominalV(starBus, t2w.transformer())).reversed().thenComparing(t2w -> t2w.transformer().getId())).toList();
        return new TwoR(starBus, sortedStarBusT2ws.get(0), sortedStarBusT2ws.get(1), sortedStarBusT2ws.get(2));
    }

    private static double getNominalV(Bus bus, TwoWindingsTransformer t2w) {
        Bus terminalBus = t2w.getTerminal1().getBusView().getBus();
        return terminalBus != null && bus != null && terminalBus.getId().equals(bus.getId()) ? t2w.getTerminal2().getVoltageLevel().getNominalV() : t2w.getTerminal1().getVoltageLevel().getNominalV();
    }

    private void replace3TwoWindingsTransformerByThreeWindingsTransformer(TwoR twoR, RegulatedTerminalControllers regulatedTerminalControllers, boolean throwException, ReportNode reportNode) {
        Substation substation = this.findSubstation(twoR, throwException);
        if (substation == null) {
            return;
        }
        if (this.anyTwoWindingsTransformerStarTerminalDefinedAsRegulatedTerminal(twoR, regulatedTerminalControllers, throwException)) {
            return;
        }
        double ratedU0 = twoR.starBusNominalV();
        ThreeWindingsTransformerAdder t3wAdder = ((ThreeWindingsTransformerAdder)((ThreeWindingsTransformerAdder)((ThreeWindingsTransformerAdder)substation.newThreeWindingsTransformer().setEnsureIdUnicity(true)).setId(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getId(twoR))).setName(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getName(twoR))).setRatedU0(ratedU0);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.addLeg(t3wAdder.newLeg1(), twoR.t2w1, twoR.isWellOrientedT2w1, ratedU0);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.addLeg(t3wAdder.newLeg2(), twoR.t2w2, twoR.isWellOrientedT2w2, ratedU0);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.addLeg(t3wAdder.newLeg3(), twoR.t2w3, twoR.isWellOrientedT2w3, ratedU0);
        ThreeWindingsTransformer t3w = t3wAdder.add();
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.setLegData(t3w.getLeg1(), twoR.t2w1, twoR.isWellOrientedT2w1, regulatedTerminalControllers, twoR);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.setLegData(t3w.getLeg2(), twoR.t2w2, twoR.isWellOrientedT2w2, regulatedTerminalControllers, twoR);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.setLegData(t3w.getLeg3(), twoR.t2w3, twoR.isWellOrientedT2w3, regulatedTerminalControllers, twoR);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyStarBusVoltageAndAngle(twoR.starBusV(), twoR.starBusAngle(), t3w);
        ArrayList<PropertyR> lostProperties = new ArrayList<PropertyR>();
        lostProperties.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyProperties(twoR.t2w1, t3w));
        lostProperties.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyProperties(twoR.t2w2, t3w));
        lostProperties.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyProperties(twoR.t2w3, t3w));
        List<ExtensionR> lostExtensions = Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyExtensions(twoR, t3w);
        ArrayList<AliasR> t2wAliases = new ArrayList<AliasR>();
        t2wAliases.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getAliases(twoR.t2w1, "1", Replace3TwoWindingsTransformersByThreeWindingsTransformers.getEnd1(twoR.isWellOrientedT2w1)));
        t2wAliases.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getAliases(twoR.t2w2, "2", Replace3TwoWindingsTransformersByThreeWindingsTransformers.getEnd1(twoR.isWellOrientedT2w2)));
        t2wAliases.addAll(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getAliases(twoR.t2w3, "3", Replace3TwoWindingsTransformersByThreeWindingsTransformers.getEnd1(twoR.isWellOrientedT2w3)));
        String t2w1Id = twoR.t2w1.getId();
        String t2w2Id = twoR.t2w2.getId();
        String t2w3Id = twoR.t2w3.getId();
        String starVoltageId = twoR.starBusVoltageLevelId();
        List<LimitsR> lostLimits = Replace3TwoWindingsTransformersByThreeWindingsTransformers.findLostLimits(twoR);
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.remove(twoR);
        List<AliasR> lostAliases = Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyAliases(t2wAliases, t3w);
        if (!lostProperties.isEmpty()) {
            lostProperties.forEach(propertyR -> LOG.warn("Property '{}' of twoWindingsTransformer '{}' was not transferred", (Object)propertyR.propertyName, (Object)propertyR.t2wId));
        }
        if (!lostExtensions.isEmpty()) {
            lostExtensions.forEach(extensionR -> LOG.warn("Extension '{}' of twoWindingsTransformer '{}' was not transferred", (Object)extensionR.extensionName, (Object)extensionR.t2wId));
        }
        if (!lostAliases.isEmpty()) {
            lostAliases.forEach(aliasR -> LOG.warn("Alias '{}' '{}' of twoWindingsTransformer '{}' was not transferred", new Object[]{aliasR.alias, aliasR.aliasType, aliasR.t2wId}));
        }
        if (!lostLimits.isEmpty()) {
            lostLimits.forEach(limitsR -> LOG.warn("OperationalLimitsGroup '{}' of twoWindingsTransformer '{}' is lost", (Object)limitsR.operationalLimitsGroupName, (Object)limitsR.t2wId));
        }
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.createReportNode(reportNode, t2w1Id, t2w2Id, t2w3Id, starVoltageId, lostProperties, lostExtensions, lostAliases, lostLimits, t3w.getId());
    }

    private static void addLeg(ThreeWindingsTransformerAdder.LegAdder legAdder, TwoWindingsTransformer t2w, boolean isWellOriented, double ratedU0) {
        legAdder.setVoltageLevel(Replace3TwoWindingsTransformersByThreeWindingsTransformers.findVoltageLevel(t2w, isWellOriented).getId()).setR(Replace3TwoWindingsTransformersByThreeWindingsTransformers.findImpedance(t2w.getR(), Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w), isWellOriented)).setX(Replace3TwoWindingsTransformersByThreeWindingsTransformers.findImpedance(t2w.getX(), Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w), isWellOriented)).setG(Replace3TwoWindingsTransformersByThreeWindingsTransformers.findAdmittance(t2w.getG(), Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w), isWellOriented)).setB(Replace3TwoWindingsTransformersByThreeWindingsTransformers.findAdmittance(t2w.getB(), Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w), isWellOriented)).setRatedU(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getRatedU1(t2w, ratedU0, isWellOriented));
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.connectAfterCreatingInternalConnection(legAdder, t2w, isWellOriented);
        legAdder.add();
    }

    private static void setLegData(ThreeWindingsTransformer.Leg leg, TwoWindingsTransformer t2w, boolean isWellOriented, RegulatedTerminalControllers regulatedTerminalControllers, TwoR twoR) {
        t2w.getOptionalRatioTapChanger().ifPresent(rtc -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyOrMoveRatioTapChanger(leg.newRatioTapChanger(), rtc, isWellOriented));
        t2w.getOptionalPhaseTapChanger().ifPresent(ptc -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyOrMovePhaseTapChanger(leg.newPhaseTapChanger(), ptc, isWellOriented));
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.getOperationalLimitsGroups1(t2w, isWellOriented).forEach(operationalLimitGroup -> TransformerUtils.copyOperationalLimitsGroup(leg.newOperationalLimitsGroup(operationalLimitGroup.getId()), operationalLimitGroup));
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.copySelectedOperationalLimitsGroup(t2w, leg, isWellOriented);
        regulatedTerminalControllers.replaceRegulatedTerminal(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal1(t2w, isWellOriented), leg.getTerminal());
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.replaceRegulatedTerminal(leg, twoR);
        TransformerUtils.copyTerminalActiveAndReactivePower(leg.getTerminal(), Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal1(t2w, isWellOriented));
    }

    private static void copySelectedOperationalLimitsGroup(TwoWindingsTransformer t2w, ThreeWindingsTransformer.Leg leg, boolean isWellOriented) {
        if (isWellOriented) {
            t2w.getSelectedOperationalLimitsGroupId1().ifPresent(arg_0 -> ((ThreeWindingsTransformer.Leg)leg).setSelectedOperationalLimitsGroup(arg_0));
        } else {
            t2w.getSelectedOperationalLimitsGroupId2().ifPresent(arg_0 -> ((ThreeWindingsTransformer.Leg)leg).setSelectedOperationalLimitsGroup(arg_0));
        }
    }

    private Substation findSubstation(TwoR twoR, boolean throwException) {
        Optional substation = twoR.t2w1.getSubstation();
        if (substation.isEmpty()) {
            ModificationLogs.logOrThrow(throwException, "TwoWindingsTransformer'" + twoR.t2w1.getId() + "' without substation");
            return null;
        }
        return (Substation)substation.get();
    }

    private boolean anyTwoWindingsTransformerStarTerminalDefinedAsRegulatedTerminal(TwoR twoR, RegulatedTerminalControllers regulatedTerminalControllers, boolean throwException) {
        if (regulatedTerminalControllers.usedAsRegulatedTerminal(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal2(twoR.t2w1, twoR.isWellOrientedT2w1))) {
            ModificationLogs.logOrThrow(throwException, "TwoWindingsTransformer'" + twoR.t2w1.getId() + "' with star terminal used as regulated terminal");
            return true;
        }
        if (regulatedTerminalControllers.usedAsRegulatedTerminal(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal2(twoR.t2w2, twoR.isWellOrientedT2w2))) {
            ModificationLogs.logOrThrow(throwException, "TwoWindingsTransformer'" + twoR.t2w2.getId() + "' with star terminal used as regulated terminal");
            return true;
        }
        if (regulatedTerminalControllers.usedAsRegulatedTerminal(Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal2(twoR.t2w3, twoR.isWellOrientedT2w3))) {
            ModificationLogs.logOrThrow(throwException, "TwoWindingsTransformer'" + twoR.t2w3.getId() + "' with star terminal used as regulated terminal");
            return true;
        }
        return false;
    }

    private static String getId(TwoR twoR) {
        return twoR.t2w1.getId() + "-" + twoR.t2w2.getId() + "-" + twoR.t2w3.getId();
    }

    private static String getName(TwoR twoR) {
        return twoR.t2w1.getNameOrId() + "-" + twoR.t2w2.getNameOrId() + "-" + twoR.t2w3.getNameOrId();
    }

    private static VoltageLevel findVoltageLevel(TwoWindingsTransformer t2w, boolean isWellOriented) {
        return isWellOriented ? t2w.getTerminal1().getVoltageLevel() : t2w.getTerminal2().getVoltageLevel();
    }

    private static double getStructuralRatio(TwoWindingsTransformer twt) {
        return twt.getRatedU1() / twt.getRatedU2();
    }

    private static double findImpedance(double impedance, double a, boolean isWellOriented) {
        return isWellOriented ? impedance : TransformerUtils.impedanceConversion(impedance, a);
    }

    private static double findAdmittance(double admittance, double a, boolean isWellOriented) {
        return isWellOriented ? admittance : TransformerUtils.admittanceConversion(admittance, a);
    }

    private static double getRatedU1(TwoWindingsTransformer t2w, double ratedU0, boolean isWellOriented) {
        return isWellOriented ? Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w) * ratedU0 : ratedU0 / Replace3TwoWindingsTransformersByThreeWindingsTransformers.getStructuralRatio(t2w);
    }

    private static void connectAfterCreatingInternalConnection(ThreeWindingsTransformerAdder.LegAdder legAdder, TwoWindingsTransformer t2w, boolean isWellOriented) {
        Terminal terminal = Replace3TwoWindingsTransformersByThreeWindingsTransformers.getTerminal1(t2w, isWellOriented);
        if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
            int newNode = terminal.getVoltageLevel().getNodeBreakerView().getMaximumNodeIndex() + 1;
            terminal.getVoltageLevel().getNodeBreakerView().newInternalConnection().setNode1(terminal.getNodeBreakerView().getNode()).setNode2(newNode).add();
            legAdder.setNode(newNode);
        } else {
            legAdder.setConnectableBus(terminal.getBusBreakerView().getConnectableBus().getId());
            Bus bus = terminal.getBusBreakerView().getBus();
            if (bus != null) {
                legAdder.setBus(bus.getId());
            }
        }
    }

    private static void copyOrMoveRatioTapChanger(RatioTapChangerAdder rtcAdder, RatioTapChanger rtc, boolean isWellOriented) {
        if (isWellOriented) {
            TransformerUtils.copyAndAddRatioTapChanger(rtcAdder, rtc);
        } else {
            TransformerUtils.copyAndMoveAndAddRatioTapChanger(rtcAdder, rtc);
        }
    }

    private static void copyOrMovePhaseTapChanger(PhaseTapChangerAdder ptcAdder, PhaseTapChanger ptc, boolean isWellOriented) {
        if (isWellOriented) {
            TransformerUtils.copyAndAddPhaseTapChanger(ptcAdder, ptc);
        } else {
            TransformerUtils.copyAndMoveAndAddPhaseTapChanger(ptcAdder, ptc);
        }
    }

    private static Collection<OperationalLimitsGroup> getOperationalLimitsGroups1(TwoWindingsTransformer t2w, boolean isWellOriented) {
        return isWellOriented ? t2w.getOperationalLimitsGroups1() : t2w.getOperationalLimitsGroups2();
    }

    private static Terminal getTerminal1(TwoWindingsTransformer t2w, boolean isWellOriented) {
        return isWellOriented ? t2w.getTerminal1() : t2w.getTerminal2();
    }

    private static Terminal getTerminal2(TwoWindingsTransformer t2w, boolean isWellOriented) {
        return isWellOriented ? t2w.getTerminal2() : t2w.getTerminal1();
    }

    private static String getEnd1(boolean isWellOriented) {
        return isWellOriented ? "1" : "2";
    }

    private static void replaceRegulatedTerminal(ThreeWindingsTransformer.Leg t3wLeg, TwoR twoR) {
        t3wLeg.getOptionalRatioTapChanger().ifPresent(rtc -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.findNewRegulatedTerminal(rtc.getRegulationTerminal(), t3wLeg.getTransformer(), twoR).ifPresent(arg_0 -> ((RatioTapChanger)rtc).setRegulationTerminal(arg_0)));
        t3wLeg.getOptionalPhaseTapChanger().ifPresent(ptc -> Replace3TwoWindingsTransformersByThreeWindingsTransformers.findNewRegulatedTerminal(ptc.getRegulationTerminal(), t3wLeg.getTransformer(), twoR).ifPresent(arg_0 -> ((PhaseTapChanger)ptc).setRegulationTerminal(arg_0)));
    }

    private static Optional<Terminal> findNewRegulatedTerminal(Terminal regulatedTerminal, ThreeWindingsTransformer t3w, TwoR twoR) {
        if (Replace3TwoWindingsTransformersByThreeWindingsTransformers.isRegulatedTerminalInTwoWindingsTransformer(regulatedTerminal, twoR.t2w1)) {
            return Optional.of(t3w.getTerminal(ThreeSides.ONE));
        }
        if (Replace3TwoWindingsTransformersByThreeWindingsTransformers.isRegulatedTerminalInTwoWindingsTransformer(regulatedTerminal, twoR.t2w2)) {
            return Optional.of(t3w.getTerminal(ThreeSides.TWO));
        }
        if (Replace3TwoWindingsTransformersByThreeWindingsTransformers.isRegulatedTerminalInTwoWindingsTransformer(regulatedTerminal, twoR.t2w3)) {
            return Optional.of(t3w.getTerminal(ThreeSides.THREE));
        }
        return Optional.empty();
    }

    private static boolean isRegulatedTerminalInTwoWindingsTransformer(Terminal regulatedTerminal, TwoWindingsTransformer t2w) {
        return regulatedTerminal != null && regulatedTerminal.getConnectable().getId().equals(t2w.getId());
    }

    private static void copyStarBusVoltageAndAngle(double starBusV, double starBusAngle, ThreeWindingsTransformer t3w) {
        if (Double.isFinite(starBusV) && starBusV > 0.0 && Double.isFinite(starBusAngle)) {
            t3w.setProperty("v", String.valueOf(starBusV));
            t3w.setProperty("angle", String.valueOf(starBusAngle));
        }
    }

    private static List<PropertyR> copyProperties(TwoWindingsTransformer t2w, ThreeWindingsTransformer t3w) {
        ArrayList<PropertyR> lostProperties = new ArrayList<PropertyR>();
        t2w.getPropertyNames().forEach(propertyName -> {
            boolean copied = Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyProperty(propertyName, t2w.getProperty(propertyName), t3w);
            if (!copied) {
                lostProperties.add(new PropertyR(t2w.getId(), (String)propertyName));
            }
        });
        return lostProperties;
    }

    private static boolean copyProperty(String propertyName, String property, ThreeWindingsTransformer t3w) {
        boolean copied = true;
        if (propertyName.startsWith(CGMES_OPERATIONAL_LIMIT_SET)) {
            if (t3w.getLeg1().getOperationalLimitsGroups().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                t3w.setProperty(propertyName, property);
            } else if (t3w.getLeg2().getOperationalLimitsGroups().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                t3w.setProperty(propertyName, property);
            } else if (t3w.getLeg3().getOperationalLimitsGroups().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                t3w.setProperty(propertyName, property);
            } else {
                copied = false;
            }
        } else if (t3w.getPropertyNames().contains(propertyName)) {
            copied = false;
        } else {
            t3w.setProperty(propertyName, property);
        }
        return copied;
    }

    private static List<ExtensionR> copyExtensions(TwoR twoR, ThreeWindingsTransformer t3w) {
        ArrayList<ExtensionR> extensions = new ArrayList<ExtensionR>();
        extensions.addAll(twoR.t2w1.getExtensions().stream().map(extension -> new ExtensionR(twoR.t2w1.getId(), extension.getName())).toList());
        extensions.addAll(twoR.t2w2.getExtensions().stream().map(extension -> new ExtensionR(twoR.t2w2.getId(), extension.getName())).toList());
        extensions.addAll(twoR.t2w3.getExtensions().stream().map(extension -> new ExtensionR(twoR.t2w3.getId(), extension.getName())).toList());
        ArrayList<ExtensionR> lostExtensions = new ArrayList<ExtensionR>();
        extensions.stream().map(extensionR -> extensionR.extensionName).collect(Collectors.toSet()).forEach(extensionName -> {
            boolean copied = Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyExtension(extensionName, twoR, t3w);
            if (!copied) {
                lostExtensions.addAll(extensions.stream().filter(extensionR -> extensionR.extensionName.equals(extensionName)).toList());
            }
        });
        return lostExtensions;
    }

    private static boolean copyExtension(String extensionName, TwoR twoR, ThreeWindingsTransformer t3w) {
        boolean copied = true;
        switch (extensionName) {
            case "twoWindingsTransformerFortescue": {
                TransformerUtils.copyAndAddFortescue((ThreeWindingsTransformerFortescueAdder)t3w.newExtension(ThreeWindingsTransformerFortescueAdder.class), (TwoWindingsTransformerFortescue)twoR.t2w1.getExtension(TwoWindingsTransformerFortescue.class), twoR.isWellOrientedT2w1, (TwoWindingsTransformerFortescue)twoR.t2w2.getExtension(TwoWindingsTransformerFortescue.class), twoR.isWellOrientedT2w2, (TwoWindingsTransformerFortescue)twoR.t2w3.getExtension(TwoWindingsTransformerFortescue.class), twoR.isWellOrientedT2w3);
                break;
            }
            case "twoWindingsTransformerPhaseAngleClock": {
                TransformerUtils.copyAndAddPhaseAngleClock((ThreeWindingsTransformerPhaseAngleClockAdder)t3w.newExtension(ThreeWindingsTransformerPhaseAngleClockAdder.class), (TwoWindingsTransformerPhaseAngleClock)twoR.t2w2.getExtension(TwoWindingsTransformerPhaseAngleClock.class), (TwoWindingsTransformerPhaseAngleClock)twoR.t2w3.getExtension(TwoWindingsTransformerPhaseAngleClock.class));
                break;
            }
            case "twoWindingsTransformerToBeEstimated": {
                TransformerUtils.copyAndAddToBeEstimated((ThreeWindingsTransformerToBeEstimatedAdder)t3w.newExtension(ThreeWindingsTransformerToBeEstimatedAdder.class), (TwoWindingsTransformerToBeEstimated)twoR.t2w1.getExtension(TwoWindingsTransformerToBeEstimated.class), (TwoWindingsTransformerToBeEstimated)twoR.t2w2.getExtension(TwoWindingsTransformerToBeEstimated.class), (TwoWindingsTransformerToBeEstimated)twoR.t2w3.getExtension(TwoWindingsTransformerToBeEstimated.class));
                break;
            }
            default: {
                copied = false;
            }
        }
        return copied;
    }

    private static List<AliasR> getAliases(TwoWindingsTransformer t2w, String leg, String end) {
        return t2w.getAliases().stream().map(alias -> new AliasR(t2w.getId(), (String)alias, t2w.getAliasType(alias).orElse(""), leg, end)).toList();
    }

    private static List<AliasR> copyAliases(List<AliasR> t2wAliases, ThreeWindingsTransformer t3w) {
        ArrayList<AliasR> lostAliases = new ArrayList<AliasR>();
        t2wAliases.forEach(aliasR -> {
            boolean copied = Replace3TwoWindingsTransformersByThreeWindingsTransformers.copyAlias(aliasR.alias, aliasR.aliasType, aliasR.leg, aliasR.end, t3w);
            if (!copied) {
                lostAliases.add((AliasR)aliasR);
            }
        });
        return lostAliases;
    }

    private static boolean copyAlias(String alias, String aliasType, String leg, String end, ThreeWindingsTransformer t3w) {
        boolean copied = true;
        if (aliasType.equals("CGMES.TransformerEnd" + end)) {
            t3w.addAlias(alias, "CGMES.TransformerEnd" + leg, true);
        } else if (aliasType.equals("CGMES.Terminal" + end)) {
            t3w.addAlias(alias, "CGMES.Terminal" + leg, true);
        } else if (aliasType.equals("CGMES.RatioTapChanger1")) {
            t3w.addAlias(alias, "CGMES.RatioTapChanger" + leg, true);
        } else if (aliasType.equals("CGMES.PhaseTapChanger1")) {
            t3w.addAlias(alias, "CGMES.PhaseTapChanger" + leg, true);
        } else {
            copied = false;
        }
        return copied;
    }

    private static void remove(TwoR twoR) {
        VoltageLevel voltageLevel = twoR.starBusVoltageLevel();
        twoR.starBusConnectables().forEach(Connectable::remove);
        voltageLevel.remove();
    }

    private static List<LimitsR> findLostLimits(TwoR twoR) {
        ArrayList<LimitsR> lostLimits = new ArrayList<LimitsR>();
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.getOperationalLimitsGroups2(twoR.t2w1, twoR.isWellOrientedT2w1).forEach(operationalLimitsGroup -> lostLimits.add(new LimitsR(twoR.t2w1.getId(), operationalLimitsGroup.getId())));
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.getOperationalLimitsGroups2(twoR.t2w2, twoR.isWellOrientedT2w2).forEach(operationalLimitsGroup -> lostLimits.add(new LimitsR(twoR.t2w2.getId(), operationalLimitsGroup.getId())));
        Replace3TwoWindingsTransformersByThreeWindingsTransformers.getOperationalLimitsGroups2(twoR.t2w3, twoR.isWellOrientedT2w3).forEach(operationalLimitsGroup -> lostLimits.add(new LimitsR(twoR.t2w3.getId(), operationalLimitsGroup.getId())));
        return lostLimits;
    }

    private static Collection<OperationalLimitsGroup> getOperationalLimitsGroups2(TwoWindingsTransformer t2w, boolean isWellOriented) {
        return isWellOriented ? t2w.getOperationalLimitsGroups2() : t2w.getOperationalLimitsGroups1();
    }

    private static void createReportNode(ReportNode reportNode, String t2w1Id, String t2w2Id, String t2w3Id, String starVoltageId, List<PropertyR> lostProperties, List<ExtensionR> lostExtensions, List<AliasR> lostAliases, List<LimitsR> lostLimits, String t3wId) {
        Set t2wIds;
        ReportNode reportNodeReplacement = ModificationReports.replace3TwoWindingsTransformersByThreeWindingsTransformersReport(reportNode);
        ModificationReports.removedTwoWindingsTransformerReport(reportNodeReplacement, t2w1Id);
        ModificationReports.removedTwoWindingsTransformerReport(reportNodeReplacement, t2w2Id);
        ModificationReports.removedTwoWindingsTransformerReport(reportNodeReplacement, t2w3Id);
        ModificationReports.removedVoltageLevelReport(reportNodeReplacement, starVoltageId);
        if (!lostProperties.isEmpty()) {
            t2wIds = lostProperties.stream().map(propertyR -> propertyR.t2wId).collect(Collectors.toSet());
            t2wIds.stream().sorted().forEach(t2wId -> {
                String properties = String.join((CharSequence)",", lostProperties.stream().filter(propertyR -> propertyR.t2wId.equals(t2wId)).map(propertyR -> propertyR.propertyName).toList());
                ModificationReports.lostTwoWindingsTransformerProperties(reportNodeReplacement, properties, t2wId);
            });
        }
        if (!lostExtensions.isEmpty()) {
            t2wIds = lostExtensions.stream().map(extensionR -> extensionR.t2wId).collect(Collectors.toSet());
            t2wIds.stream().sorted().forEach(t2wId -> {
                String extensions = String.join((CharSequence)",", lostExtensions.stream().filter(extensionR -> extensionR.t2wId.equals(t2wId)).map(extensionR -> extensionR.extensionName).toList());
                ModificationReports.lostTwoWindingsTransformerExtensions(reportNodeReplacement, extensions, t2wId);
            });
        }
        if (!lostAliases.isEmpty()) {
            t2wIds = lostAliases.stream().map(aliasR -> aliasR.t2wId).collect(Collectors.toSet());
            t2wIds.stream().sorted().forEach(t2wId -> {
                String aliases = lostAliases.stream().filter(aliasR -> aliasR.t2wId.equals(t2wId)).map(AliasR::alias).collect(Collectors.joining(","));
                ModificationReports.lostTwoWindingsTransformerAliases(reportNodeReplacement, aliases, t2wId);
            });
        }
        if (!lostLimits.isEmpty()) {
            t2wIds = lostLimits.stream().map(limitsR -> limitsR.t2wId).collect(Collectors.toSet());
            t2wIds.stream().sorted().forEach(t2wId -> {
                String limits = lostLimits.stream().filter(limitsR -> limitsR.t2wId.equals(t2wId)).map(LimitsR::operationalLimitsGroupName).collect(Collectors.joining(","));
                ModificationReports.lostTwoWindingsTransformerOperationalLimitsGroups(reportNodeReplacement, limits, t2wId);
            });
        }
        ModificationReports.createdThreeWindingsTransformerReport(reportNodeReplacement, t3wId);
    }

    private record TwoR(TwoWindingsTransformer t2w1, boolean isWellOrientedT2w1, TwoWindingsTransformer t2w2, boolean isWellOrientedT2w2, TwoWindingsTransformer t2w3, boolean isWellOrientedT2w3, String starBusId, VoltageLevel starBusVoltageLevel, double starBusV, double starBusAngle, List<Connectable> starBusConnectables) {
        TwoR(Bus starBus, TransformerAndStarBusSide t1, TransformerAndStarBusSide t2, TransformerAndStarBusSide t3) {
            this(t1.transformer(), TwoR.isWellOriented(t1), t2.transformer(), TwoR.isWellOriented(t2), t3.transformer(), TwoR.isWellOriented(t3), starBus.getId(), starBus.getVoltageLevel(), starBus.getV(), starBus.getAngle(), starBus.getConnectedTerminalStream().map(Terminal::getConnectable).toList());
        }

        private static boolean isWellOriented(TransformerAndStarBusSide transfoAndStarBusSide) {
            return transfoAndStarBusSide.side() == TwoSides.TWO;
        }

        public String starBusVoltageLevelId() {
            return this.starBusVoltageLevel.getId();
        }

        public double starBusNominalV() {
            return this.starBusVoltageLevel.getNominalV();
        }
    }

    record TransformerAndStarBusSide(TwoWindingsTransformer transformer, TwoSides side) {
    }

    private record LimitsR(String t2wId, String operationalLimitsGroupName) {
    }

    private record AliasR(String t2wId, String alias, String aliasType, String leg, String end) {
    }

    private record ExtensionR(String t2wId, String extensionName) {
    }

    private record PropertyR(String t2wId, String propertyName) {
    }
}

