/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetGeneratorToLocalRegulation
extends AbstractNetworkModification {
    private final String generatorId;
    private static final Logger LOG = LoggerFactory.getLogger(SetGeneratorToLocalRegulation.class);

    public SetGeneratorToLocalRegulation(String generatorId) {
        this.generatorId = Objects.requireNonNull(generatorId);
    }

    @Override
    public String getName() {
        return "SetGeneratorToLocalRegulation";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Generator generator = network.getGenerator(this.generatorId);
        if (generator == null) {
            ModificationLogs.logOrThrow(throwException, "Generator '" + this.generatorId + "' not found");
        } else if (!this.isGeneratorRegulatingLocally(generator)) {
            this.setLocalRegulation(generator, reportNode);
        }
    }

    private void setLocalRegulation(Generator generator, ReportNode reportNode) {
        generator.setTargetV(this.calculateTargetVoltage(generator));
        generator.setRegulatingTerminal(generator.getTerminal());
        LOG.info("Changed regulation for generator: {} to local instead of remote", (Object)generator.getId());
        ModificationReports.generatorLocalRegulationReport(reportNode, generator.getId());
    }

    private double calculateTargetVoltage(Generator generator) {
        Optional<Generator> referenceGenerator;
        double localNominalV = generator.getTerminal().getVoltageLevel().getNominalV();
        Bus bus = generator.getTerminal().getBusView().getBus();
        if (bus != null && (referenceGenerator = this.getReferenceGenerator(bus, localNominalV)).isPresent()) {
            double targetV = referenceGenerator.get().getTargetV();
            this.checkLocalGeneratorsWithWrongTargetV(bus, targetV);
            return targetV;
        }
        double remoteTargetV = generator.getTargetV();
        double remoteNominalV = generator.getRegulatingTerminal().getVoltageLevel().getNominalV();
        return localNominalV * remoteTargetV / remoteNominalV;
    }

    private boolean isGeneratorRegulatingLocally(Generator generator) {
        return generator.getId().equals(generator.getRegulatingTerminal().getConnectable().getId());
    }

    private Optional<Generator> getReferenceGenerator(Bus bus, double localNominalV) {
        return bus.getGeneratorStream().filter(g -> !g.getId().equals(this.generatorId) && this.isGeneratorRegulatingLocally((Generator)g)).min(Comparator.comparing(g -> Math.abs(g.getTargetV() - localNominalV)));
    }

    private void checkLocalGeneratorsWithWrongTargetV(Bus bus, double targetV) {
        bus.getGeneratorStream().filter(g -> !g.getId().equals(this.generatorId) && this.isGeneratorRegulatingLocally((Generator)g) && g.getTargetV() != targetV).forEach(gen -> LOG.warn("Generator {} has wrong target voltage {}", (Object)gen.getId(), (Object)gen.getTargetV()));
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        Generator generator = network.getGenerator(this.generatorId);
        this.impact = generator == null ? NetworkModificationImpact.CANNOT_BE_APPLIED : (this.isGeneratorRegulatingLocally(generator) ? NetworkModificationImpact.NO_IMPACT_ON_NETWORK : DEFAULT_IMPACT);
        return this.impact;
    }
}

