/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.math.graph.TraverseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectFeedersToBusbarSections
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectFeedersToBusbarSections.class);
    private static final String NAME = "ConnectFeedersToBusbarSections";
    private final List<Connectable> connectablesToConnect;
    private final List<BusbarSection> busbarSectionsToConnect;
    private final boolean connectCouplingDevices;
    private final String couplingDeviceSwitchPrefixId;

    ConnectFeedersToBusbarSections(List<Connectable> connectablesToConnect, List<BusbarSection> busbarSectionsToConnect, boolean connectCouplingDevices, String couplingDeviceSwitchPrefixId) {
        this.connectablesToConnect = Objects.requireNonNull(connectablesToConnect);
        this.busbarSectionsToConnect = Objects.requireNonNull(busbarSectionsToConnect);
        this.connectCouplingDevices = connectCouplingDevices;
        this.couplingDeviceSwitchPrefixId = couplingDeviceSwitchPrefixId;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (this.busbarSectionsToConnect.isEmpty()) {
            ModificationLogs.logOrThrow(throwException, "No busbar section provided.");
            ModificationReports.noBusbarSectionReport(reportNode);
            return;
        }
        if (this.busbarSectionsToConnect.stream().anyMatch(b -> b.getNetwork() != network)) {
            ModificationLogs.logOrThrow(throwException, "All busbar sections must be in the network passed to the method.");
            ModificationReports.wrongNetworkReport(reportNode);
            return;
        }
        List<VoltageLevel> distinctVoltageLevels = this.busbarSectionsToConnect.stream().map(bbs -> bbs.getTerminal().getVoltageLevel()).distinct().toList();
        if (distinctVoltageLevels.size() != 1) {
            ModificationLogs.logOrThrow(throwException, "All busbar sections must all belong to the same voltage level.");
            ModificationReports.busbarSectionNotInTheSameVoltageLevelReport(reportNode);
            return;
        }
        VoltageLevel voltageLevel = distinctVoltageLevels.get(0);
        if (this.busbarSectionsToConnect.stream().map(bbs -> bbs.getExtension(BusbarSectionPosition.class)).anyMatch(Objects::isNull)) {
            ModificationLogs.logOrThrow(throwException, "All busbar sections must have a BusbarSectionPosition extension.");
            ModificationReports.busbarSectionsWithoutPositionReport(reportNode, voltageLevel.getId());
            return;
        }
        List<Connectable<?>> connectedFeeders = this.connectFeeders(voltageLevel, namingStrategy);
        LOGGER.info("{} are connected to busbar sections {}", connectedFeeders, this.busbarSectionsToConnect);
        ModificationReports.connectedFeedersReport(reportNode, connectedFeeders, this.busbarSectionsToConnect);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        if (this.busbarSectionsToConnect.isEmpty() || this.busbarSectionsToConnect.stream().anyMatch(b -> b.getNetwork() != network) || this.busbarSectionsToConnect.stream().map(bbs -> bbs.getExtension(BusbarSectionPosition.class)).anyMatch(Objects::isNull) || this.busbarSectionsToConnect.stream().map(bbs -> bbs.getTerminal().getVoltageLevel()).distinct().count() != 1L) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private List<Connectable<?>> connectFeeders(VoltageLevel vl, NamingStrategy namingStrategy) {
        ArrayList connectedFeeders = new ArrayList();
        Map<Integer, List<BusbarSection>> busbarSectionsByIndex = vl.getNodeBreakerView().getBusbarSectionStream().collect(Collectors.groupingBy(this::getSectionIndex));
        Map<Integer, List<BusbarSection>> busbarSectionsToConnectByIndex = this.busbarSectionsToConnect.stream().collect(Collectors.groupingBy(this::getSectionIndex));
        busbarSectionsToConnectByIndex.forEach((sectionIndex, busbarSectionList) -> {
            List<BusbarSection> existingBusbarSections = busbarSectionsByIndex.getOrDefault(sectionIndex, Collections.emptyList());
            Map<Integer, SwitchCreationData> switchesToCreate = this.getSwitchesConnectingConnectablesToExistingBusbarSections(existingBusbarSections);
            busbarSectionList.forEach(bbs -> this.createSwitchesForBusbarSection(vl, namingStrategy, switchesToCreate, (BusbarSection)bbs, connectedFeeders));
        });
        return connectedFeeders;
    }

    private void createSwitchesForBusbarSection(VoltageLevel vl, NamingStrategy namingStrategy, Map<Integer, SwitchCreationData> switchesToCreate, BusbarSection bbs, List<Connectable<?>> connectedFeeders) {
        int bbsNode = bbs.getTerminal().getNodeBreakerView().getNode();
        switchesToCreate.forEach((node, switchData) -> {
            if (this.shouldSkipSwitchCreation(bbs, (SwitchCreationData)switchData)) {
                return;
            }
            switchData.connectables.stream().filter(c -> !(c instanceof BusbarSection)).forEach(connectedFeeders::add);
            this.createSwitch(vl, namingStrategy, bbsNode, (int)node, switchData.connectables.get(0), (SwitchCreationData)switchData);
        });
    }

    private Map<Integer, SwitchCreationData> getSwitchesConnectingConnectablesToExistingBusbarSections(List<BusbarSection> existingBusbarSections) {
        HashMap<Integer, SwitchCreationData> switchesToCreate = new HashMap<Integer, SwitchCreationData>();
        for (BusbarSection busbarSection : existingBusbarSections) {
            switchesToCreate.putAll(this.getSwitchesConnectingConnectables(busbarSection));
        }
        return switchesToCreate;
    }

    private boolean shouldSkipSwitchCreation(BusbarSection bbs, SwitchCreationData data) {
        boolean isCouplingDevice = this.isOnlyBusbarSections(data.connectables);
        if (data.startBusbarSection == bbs) {
            return true;
        }
        if (data.connectables.contains(bbs) && !isCouplingDevice) {
            return true;
        }
        if (isCouplingDevice) {
            boolean betweenSections = this.isCouplingDeviceBetweenSections(data);
            if (betweenSections && data.connectables.contains(bbs)) {
                return true;
            }
            long count = data.connectables.stream().filter(b -> b.equals((Object)bbs)).count();
            return !betweenSections && count > 1L;
        }
        return false;
    }

    private void createSwitch(VoltageLevel vl, NamingStrategy namingStrategy, int bbsNode, int node, Connectable<?> connectable, SwitchCreationData switchCreationData) {
        boolean isDisconnector = switchCreationData.sw.getKind() == SwitchKind.DISCONNECTOR;
        String switchId = this.getSwitchId(namingStrategy, node, connectable, isDisconnector, bbsNode, vl.getId());
        String switchName = this.getSwitchName(namingStrategy, node, connectable, isDisconnector, bbsNode, vl.getId());
        if (isDisconnector) {
            TopologyModificationUtils.createNBDisconnector(bbsNode, node, switchId, switchName, vl.getNodeBreakerView(), true, switchCreationData.sw.isFictitious());
        } else {
            TopologyModificationUtils.createNBBreaker(bbsNode, node, switchId, switchName, vl.getNodeBreakerView(), true, switchCreationData.sw.isFictitious());
        }
    }

    private String getSwitchId(NamingStrategy namingStrategy, int connectableNode, Connectable<?> connectable, boolean isDisconnector, int bbsNode, String voltageLevelId) {
        String baseId = connectable instanceof BusbarSection ? this.couplingDeviceSwitchPrefixId : namingStrategy.getSwitchBaseId(connectable, this.getSide(connectable, voltageLevelId));
        return isDisconnector ? namingStrategy.getDisconnectorId(baseId, bbsNode, connectableNode) : namingStrategy.getBreakerId(baseId, bbsNode, connectableNode);
    }

    private String getSwitchName(NamingStrategy namingStrategy, int connectableNode, Connectable<?> connectable, boolean isDisconnector, int bbsNode, String voltageLevelId) {
        String baseId = connectable instanceof BusbarSection ? this.couplingDeviceSwitchPrefixId : namingStrategy.getSwitchBaseName(connectable, this.getSide(connectable, voltageLevelId));
        return isDisconnector ? namingStrategy.getDisconnectorName(baseId, bbsNode, connectableNode) : namingStrategy.getBreakerName(baseId, bbsNode, connectableNode);
    }

    private int getSide(Connectable<?> connectable, String voltageLevelId) {
        if (connectable instanceof Branch) {
            Branch branch = (Branch)connectable;
            return branch.getTerminal(voltageLevelId).getSide().getNum();
        }
        if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer threeWindingsTransformer = (ThreeWindingsTransformer)connectable;
            return threeWindingsTransformer.getTerminal(voltageLevelId).getSide().getNum();
        }
        return 0;
    }

    private Map<Integer, SwitchCreationData> getSwitchesConnectingConnectables(BusbarSection busbarSection) {
        Objects.requireNonNull(busbarSection, "Busbar section must not be null");
        Terminal terminal = busbarSection.getTerminal();
        int startNode = terminal.getNodeBreakerView().getNode();
        VoltageLevel.NodeBreakerView nodeBreakerView = terminal.getVoltageLevel().getNodeBreakerView();
        HashMap<Integer, SwitchCreationData> result = new HashMap<Integer, SwitchCreationData>();
        int[] firstNode = new int[1];
        HashMap<Integer, List> foundConnectables = new HashMap<Integer, List>();
        HashMap switchesPerNode = new HashMap();
        nodeBreakerView.traverse(startNode, (fromNode, sw, toNode) -> {
            Optional terminalOpt;
            if (sw == null) {
                return TraverseResult.CONTINUE;
            }
            if (fromNode == startNode) {
                firstNode[0] = toNode;
                switchesPerNode.put(toNode, sw);
            }
            if ((terminalOpt = nodeBreakerView.getOptionalTerminal(toNode)).isEmpty()) {
                return TraverseResult.CONTINUE;
            }
            Connectable connectable = ((Terminal)terminalOpt.get()).getConnectable();
            List connectablesAtNode = foundConnectables.getOrDefault(firstNode[0], new ArrayList());
            connectablesAtNode.add(connectable);
            foundConnectables.put(firstNode[0], connectablesAtNode);
            return TraverseResult.TERMINATE_PATH;
        });
        foundConnectables.forEach((node, connectable) -> {
            if (this.keepSwitch((List<Connectable<?>>)connectable, busbarSection)) {
                result.put((Integer)node, new SwitchCreationData((Switch)switchesPerNode.get(node), (List<Connectable<?>>)connectable, busbarSection));
            }
        });
        return result;
    }

    private boolean keepSwitch(List<Connectable<?>> connectables, BusbarSection startBusbarSection) {
        boolean isOnlyBusbarSections = this.isOnlyBusbarSections(connectables);
        if (isOnlyBusbarSections) {
            int startBusbarSectionPosition = ((BusbarSectionPosition)startBusbarSection.getExtension(BusbarSectionPosition.class)).getBusbarIndex();
            boolean isCouplingDevice = connectables.stream().map(c -> (BusbarSection)c).map(b -> b.getExtension(BusbarSectionPosition.class)).anyMatch(position -> ((BusbarSectionPosition)position).getBusbarIndex() != startBusbarSectionPosition);
            return isCouplingDevice && this.connectCouplingDevices;
        }
        return connectables.stream().anyMatch(this.connectablesToConnect::contains);
    }

    private int getSectionIndex(BusbarSection bbs) {
        return ((BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class)).getSectionIndex();
    }

    private boolean isOnlyBusbarSections(List<Connectable<?>> connectables) {
        return connectables.stream().allMatch(BusbarSection.class::isInstance);
    }

    private boolean isCouplingDeviceBetweenSections(SwitchCreationData data) {
        return data.connectables.stream().map(BusbarSection.class::cast).map(this::getSectionIndex).distinct().count() == 2L;
    }

    public record SwitchCreationData(Switch sw, List<Connectable<?>> connectables, BusbarSection startBusbarSection) {
    }
}

