/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.iidm.modification.topology.AbstractCreateConnectableFeederBays;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import java.util.Objects;
import java.util.Optional;

public class CreateBranchFeederBays
extends AbstractCreateConnectableFeederBays {
    private final BranchAdder<?, ?> branchAdder;
    private final String busOrBbsId1;
    private final String busOrBbsId2;
    private final Integer positionOrder1;
    private final Integer positionOrder2;
    private final String feederName1;
    private final String feederName2;
    private final ConnectablePosition.Direction direction1;
    private final ConnectablePosition.Direction direction2;
    private final boolean logOrThrowIfIncorrectPositionOrder1;
    private final boolean logOrThrowIfIncorrectPositionOrder2;

    CreateBranchFeederBays(BranchAdder<?, ?> branchAdder, String busOrBbsId1, String busOrBbsId2, Integer positionOrder1, Integer positionOrder2, String feederName1, String feederName2, ConnectablePosition.Direction direction1, ConnectablePosition.Direction direction2, boolean logOrThrowIfIncorrectPositionOrder1, boolean logOrThrowIfIncorrectPositionOrder2) {
        super(1, 2);
        this.branchAdder = Objects.requireNonNull(branchAdder);
        this.busOrBbsId1 = Objects.requireNonNull(busOrBbsId1);
        this.busOrBbsId2 = Objects.requireNonNull(busOrBbsId2);
        this.positionOrder1 = positionOrder1;
        this.positionOrder2 = positionOrder2;
        this.feederName1 = feederName1;
        this.feederName2 = feederName2;
        this.direction1 = Objects.requireNonNull(direction1);
        this.direction2 = Objects.requireNonNull(direction2);
        this.logOrThrowIfIncorrectPositionOrder1 = logOrThrowIfIncorrectPositionOrder1;
        this.logOrThrowIfIncorrectPositionOrder2 = logOrThrowIfIncorrectPositionOrder2;
    }

    @Override
    public String getName() {
        return "CreateBranchFeederBays";
    }

    @Override
    protected String getBusOrBusbarSectionId(int side) {
        if (side == 1) {
            return this.busOrBbsId1;
        }
        if (side == 2) {
            return this.busOrBbsId2;
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected void setBus(int side, Bus bus, String voltageLevelId) {
        if (side == 1) {
            this.branchAdder.setConnectableBus1(bus.getId()).setBus1(bus.getId()).setVoltageLevel1(voltageLevelId);
        } else if (side == 2) {
            this.branchAdder.setConnectableBus2(bus.getId()).setBus2(bus.getId()).setVoltageLevel2(voltageLevelId);
        } else {
            throw CreateBranchFeederBays.createSideIllegalStateException(side);
        }
    }

    @Override
    protected void setNode(int side, int node, String voltageLevelId) {
        if (side == 1) {
            this.branchAdder.setNode1(node).setVoltageLevel1(voltageLevelId);
        } else if (side == 2) {
            this.branchAdder.setNode2(node).setVoltageLevel2(voltageLevelId);
        } else {
            throw CreateBranchFeederBays.createSideIllegalStateException(side);
        }
    }

    @Override
    protected Connectable<?> add() {
        return (Connectable)this.branchAdder.add();
    }

    @Override
    protected VoltageLevel getVoltageLevel(int side, Connectable<?> connectable) {
        Branch branch = (Branch)connectable;
        if (side == 1) {
            return branch.getTerminal1().getVoltageLevel();
        }
        if (side == 2) {
            return branch.getTerminal2().getVoltageLevel();
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected Integer getPositionOrder(int side) {
        if (side == 1) {
            return this.positionOrder1;
        }
        if (side == 2) {
            return this.positionOrder2;
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected Optional<String> getFeederName(int side) {
        if (side == 1) {
            return Optional.ofNullable(this.feederName1);
        }
        if (side == 2) {
            return Optional.ofNullable(this.feederName2);
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected ConnectablePosition.Direction getDirection(int side) {
        if (side == 1) {
            return this.direction1;
        }
        if (side == 2) {
            return this.direction2;
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected int getNode(int side, Connectable<?> connectable) {
        Branch branch = (Branch)connectable;
        if (side == 1) {
            return branch.getTerminal1().getNodeBreakerView().getNode();
        }
        if (side == 2) {
            return branch.getTerminal2().getNodeBreakerView().getNode();
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected ConnectablePositionAdder.FeederAdder<?> getFeederAdder(int side, ConnectablePositionAdder<?> connectablePositionAdder) {
        if (side == 1) {
            return connectablePositionAdder.newFeeder1();
        }
        if (side == 2) {
            return connectablePositionAdder.newFeeder2();
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    @Override
    protected boolean getLogOrThrowIfIncorrectPositionOrder(int side) {
        if (side == 1) {
            return this.logOrThrowIfIncorrectPositionOrder1;
        }
        if (side == 2) {
            return this.logOrThrowIfIncorrectPositionOrder2;
        }
        throw CreateBranchFeederBays.createSideIllegalStateException(side);
    }

    private static IllegalStateException createSideIllegalStateException(int side) {
        return new IllegalStateException("Unexpected side: " + side);
    }
}

