/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.google.auto.service.AutoService;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.List;

@AutoService(value={NamingStrategy.class})
public class DefaultNamingStrategy
implements NamingStrategy {
    public static final String STRATEGY_NAME = "Default";
    private static final String SEPARATOR = "_";
    private static final String DISCONNECTOR_NAMEBASE = "DISCONNECTOR";
    private static final String BREAKER_NAMEBASE = "BREAKER";
    private static final String SWITCH_NAMEBASE = "SW";
    private static final String BUS_NAMEBASE = "BUS";

    @Override
    public final String getName() {
        return STRATEGY_NAME;
    }

    @Override
    public final String getSectioningPrefix(String baseId, BusbarSection bbs, int busBarNum, int section1Num, int section2Num) {
        return baseId;
    }

    @Override
    public final String getChunkPrefix(String baseId, List<SwitchKind> switchKindList, int busBarNum, int section1Num, int section2Num) {
        return baseId;
    }

    @Override
    public final String getDisconnectorId(String baseId, int id1Num, int id2Num) {
        return baseId + "_DISCONNECTOR_" + id1Num + SEPARATOR + id2Num;
    }

    @Override
    public final String getDisconnectorId(BusbarSection bbs, String baseId, int id1Num, int id2Num, int side) {
        return this.getDisconnectorId(baseId, id1Num, id2Num);
    }

    @Override
    public final String getDisconnectorBetweenChunksId(BusbarSection bbs, String baseId, int id1Num, int id2Num) {
        return this.getDisconnectorId(baseId, id1Num, id2Num);
    }

    @Override
    public final String getBreakerId(String baseId) {
        return baseId + "_BREAKER";
    }

    @Override
    public final String getBreakerId(String baseId, int id1Num, int id2Num) {
        return baseId + "_BREAKER_" + id1Num + SEPARATOR + id2Num;
    }

    @Override
    public final String getSwitchId(String baseId) {
        return baseId + "_SW";
    }

    @Override
    public final String getSwitchId(String baseId, int idNum) {
        return baseId + "_SW_" + idNum;
    }

    @Override
    public final String getSwitchId(String baseId, int id1Num, int id2Num) {
        return baseId + "_SW_" + id1Num + SEPARATOR + id2Num;
    }

    @Override
    public final String getBusbarId(String baseId, int id1Num, int id2Num) {
        return baseId + SEPARATOR + id1Num + SEPARATOR + id2Num;
    }

    @Override
    public final String getBusbarId(String baseId, List<SwitchKind> switchKindList, int id1Num, int id2Num) {
        return baseId + SEPARATOR + id1Num + SEPARATOR + id2Num;
    }

    @Override
    public final String getBusId(String baseId) {
        return baseId + "_BUS";
    }

    @Override
    public final String getSwitchBaseId(Connectable<?> connectable, int side) {
        return connectable.getId() + String.valueOf(side == 0 ? "" : Integer.valueOf(side));
    }

    @Override
    public final String getSwitchBaseId(VoltageLevel voltageLevel, BusbarSection bbs1, BusbarSection bbs2) {
        return voltageLevel.getId();
    }
}

