/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;

public class MoveFeederBay
extends AbstractNetworkModification {
    private final String connectableId;
    private final String targetBusOrBusBarSectionId;
    private final String targetVoltageLevelId;
    private final Terminal terminal;

    MoveFeederBay(String connectableId, String targetBusOrBusBarId, String targetVoltageLevelId, Terminal terminal) {
        this.connectableId = Objects.requireNonNull(connectableId);
        this.targetBusOrBusBarSectionId = Objects.requireNonNull(targetBusOrBusBarId);
        this.targetVoltageLevelId = Objects.requireNonNull(targetVoltageLevelId);
        this.terminal = Objects.requireNonNull(terminal);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Connectable connectable = network.getConnectable(this.connectableId);
        if (!this.validateConnectable(connectable, throwException, reportNode)) {
            return;
        }
        VoltageLevel voltageLevel = network.getVoltageLevel(this.targetVoltageLevelId);
        if (voltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            this.moveInNodeBreakerTopology(network, connectable, voltageLevel, namingStrategy, reportNode);
        } else {
            this.moveInBusBreakerTopology(this.terminal);
        }
    }

    private void moveInNodeBreakerTopology(Network network, Connectable<?> connectable, VoltageLevel voltageLevel, NamingStrategy namingStrategy, ReportNode reportNode) {
        TopologyModificationUtils.cleanNodeBreakerTopology(this.terminal, this.connectableId, reportNode);
        int side = this.getSideFromTerminal(this.terminal, connectable);
        int connectableNode = TopologyModificationUtils.createTopologyAndGetConnectableNode(side, this.targetBusOrBusBarSectionId, network, voltageLevel, connectable, namingStrategy, reportNode);
        this.terminal.getNodeBreakerView().moveConnectable(connectableNode, voltageLevel.getId());
    }

    private void moveInBusBreakerTopology(Terminal terminal) {
        terminal.getBusBreakerView().moveConnectable(this.targetBusOrBusBarSectionId, terminal.isConnected());
    }

    private int getSideFromTerminal(Terminal terminal, Connectable<?> connectable) {
        if (connectable instanceof Injection) {
            return 0;
        }
        if (connectable instanceof Branch || connectable instanceof ThreeWindingsTransformer) {
            return terminal.getSide().getNum();
        }
        throw new IllegalStateException("Unsupported connectable type: " + connectable.getClass().getSimpleName());
    }

    @Override
    public String getName() {
        return "MoveFeederBay";
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Connectable connectable = network.getConnectable(this.connectableId);
        BusbarSection targetBusbarSection = network.getBusbarSection(this.targetBusOrBusBarSectionId);
        if (connectable == null || connectable instanceof BusbarSection || targetBusbarSection == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            return this.impact;
        }
        VoltageLevel targetVoltageLevel = targetBusbarSection.getTerminal().getVoltageLevel();
        boolean hasTerminalInTargetVoltageLevel = connectable.getTerminals().stream().anyMatch(t -> t.getVoltageLevel().getId().equals(targetVoltageLevel.getId()));
        if (!hasTerminalInTargetVoltageLevel) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            return this.impact;
        }
        return this.impact;
    }

    private boolean validateConnectable(Connectable<?> connectable, boolean throwException, ReportNode reportNode) {
        if (connectable == null) {
            ModificationReports.notFoundConnectableReport(reportNode, this.connectableId);
            ModificationLogs.logOrThrow(throwException, "Connectable not found: " + this.connectableId);
            return false;
        }
        if (connectable instanceof BusbarSection) {
            ModificationReports.moveFeederBayBusbarSectionReport(reportNode, this.connectableId);
            ModificationLogs.logOrThrow(throwException, "BusbarSection connectables are not allowed as MoveFeederBay input: " + this.connectableId);
            return false;
        }
        return true;
    }
}

