/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFeederBay
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveFeederBay.class);
    private final String connectableId;

    public RemoveFeederBay(String connectableId) {
        this.connectableId = Objects.requireNonNull(connectableId);
    }

    @Override
    public String getName() {
        return "RemoveFeederBay";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Connectable connectable = network.getConnectable(this.connectableId);
        if (!this.checkConnectable(throwException, reportNode, connectable)) {
            return;
        }
        TopologyModificationUtils.cleanNodeBreakerTopology(network, this.connectableId, reportNode);
        connectable.remove();
        ModificationReports.removedConnectableReport(reportNode, this.connectableId);
        LOGGER.info("Connectable {} removed", (Object)this.connectableId);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Connectable connectable = network.getConnectable(this.connectableId);
        if (connectable == null || connectable instanceof BusbarSection) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private boolean checkConnectable(boolean throwException, ReportNode reportNode, Connectable<?> connectable) {
        if (connectable instanceof BusbarSection) {
            ModificationReports.removeFeederBayBusbarSectionReport(reportNode, this.connectableId);
            ModificationLogs.logOrThrow(throwException, "BusbarSection connectables are not allowed as RemoveFeederBay input: " + this.connectableId);
            return false;
        }
        if (connectable == null) {
            ModificationReports.notFoundConnectableReport(reportNode, this.connectableId);
            ModificationLogs.logOrThrow(throwException, "Connectable not found: " + this.connectableId);
            return false;
        }
        return true;
    }
}

