/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.RemoveVoltageLevel;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveSubstation
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveSubstation.class);
    private final String substationId;

    RemoveSubstation(String substationId) {
        this.substationId = Objects.requireNonNull(substationId);
    }

    @Override
    public String getName() {
        return "RemoveSubstation";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Substation substation = network.getSubstation(this.substationId);
        if (substation == null) {
            ModificationReports.notFoundSubstationReport(reportNode, this.substationId);
            ModificationLogs.logOrThrow(throwException, "Substation not found: " + this.substationId);
            return;
        }
        List<String> vlIds = substation.getVoltageLevelStream().map(Identifiable::getId).toList();
        vlIds.forEach(id -> new RemoveVoltageLevel((String)id).apply(network, true, reportNode));
        substation.remove();
        ModificationReports.removedSubstationReport(reportNode, this.substationId);
        LOGGER.info("Substation {} and its voltage levels have been removed", (Object)this.substationId);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        if (network.getSubstation(this.substationId) == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }
}

