/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.math.graph.TraverseResult;
import java.util.Objects;
import java.util.Set;

final class TrippingTopologyTraverser {
    private TrippingTopologyTraverser() {
    }

    private static boolean isOpenable(Switch aSwitch) {
        return !aSwitch.isOpen() && !aSwitch.isFictitious() && aSwitch.getKind() == SwitchKind.BREAKER;
    }

    static void traverse(Terminal terminal, final Set<Switch> switchesToOpen, final Set<Terminal> terminalsToDisconnect, final Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(terminal);
        Objects.requireNonNull(switchesToOpen);
        Objects.requireNonNull(terminalsToDisconnect);
        terminal.traverse(new Terminal.TopologyTraverser(){

            public TraverseResult traverse(Terminal terminal, boolean connected) {
                if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER) {
                    if (connected) {
                        terminalsToDisconnect.add(terminal);
                        if (traversedTerminals != null) {
                            traversedTerminals.add(terminal);
                        }
                    }
                    return TraverseResult.TERMINATE_PATH;
                }
                if (traversedTerminals != null) {
                    traversedTerminals.add(terminal);
                }
                return TraverseResult.CONTINUE;
            }

            public TraverseResult traverse(Switch aSwitch) {
                if (TrippingTopologyTraverser.isOpenable(aSwitch)) {
                    switchesToOpen.add(aSwitch);
                    return TraverseResult.TERMINATE_PATH;
                }
                return aSwitch.isOpen() ? TraverseResult.TERMINATE_PATH : TraverseResult.CONTINUE;
            }
        });
    }
}

