/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.extensions.VoltageRegulation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegulatedTerminalControllers {
    private final Network network;
    private final Map<TerminalRef, List<Identifiable<?>>> controllers;

    public RegulatedTerminalControllers(Network network) {
        this.network = network;
        this.controllers = new HashMap();
        this.findRegulatedTerminalControllers();
    }

    private void findRegulatedTerminalControllers() {
        this.network.getIdentifiables().forEach(identifiable -> {
            List<TerminalRef> regulatedTerminals = this.findRegulatedTerminals((Identifiable<?>)identifiable);
            regulatedTerminals.forEach(regulatedTerminal -> this.controllers.computeIfAbsent((TerminalRef)regulatedTerminal, k -> new ArrayList()).add(identifiable));
        });
    }

    private List<TerminalRef> findRegulatedTerminals(Identifiable<?> identifiable) {
        List<TerminalRef> terminals = this.findRegulatedTerminalsInModel(identifiable);
        terminals.addAll(this.findRegulatedTerminalsInExtensions(identifiable));
        return terminals;
    }

    private List<TerminalRef> findRegulatedTerminalsInModel(Identifiable<?> identifiable) {
        ArrayList<TerminalRef> regulatedTerminals = new ArrayList<TerminalRef>();
        switch (identifiable.getType()) {
            case TWO_WINDINGS_TRANSFORMER: {
                TwoWindingsTransformer t2w = (TwoWindingsTransformer)identifiable;
                t2w.getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.add(regulatedTerminals, rtc.getRegulationTerminal()));
                t2w.getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.add(regulatedTerminals, ptc.getRegulationTerminal()));
                break;
            }
            case THREE_WINDINGS_TRANSFORMER: {
                ThreeWindingsTransformer t3w = (ThreeWindingsTransformer)identifiable;
                t3w.getLeg1().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.add(regulatedTerminals, rtc.getRegulationTerminal()));
                t3w.getLeg1().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.add(regulatedTerminals, ptc.getRegulationTerminal()));
                t3w.getLeg2().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.add(regulatedTerminals, rtc.getRegulationTerminal()));
                t3w.getLeg2().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.add(regulatedTerminals, ptc.getRegulationTerminal()));
                t3w.getLeg3().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.add(regulatedTerminals, rtc.getRegulationTerminal()));
                t3w.getLeg3().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.add(regulatedTerminals, ptc.getRegulationTerminal()));
                break;
            }
            case GENERATOR: {
                Generator generator = (Generator)identifiable;
                RegulatedTerminalControllers.add(regulatedTerminals, generator.getRegulatingTerminal());
                break;
            }
            case SHUNT_COMPENSATOR: {
                ShuntCompensator shuntCompensator = (ShuntCompensator)identifiable;
                RegulatedTerminalControllers.add(regulatedTerminals, shuntCompensator.getRegulatingTerminal());
                break;
            }
            case STATIC_VAR_COMPENSATOR: {
                StaticVarCompensator staticVarCompensator = (StaticVarCompensator)identifiable;
                RegulatedTerminalControllers.add(regulatedTerminals, staticVarCompensator.getRegulatingTerminal());
                break;
            }
            case HVDC_CONVERTER_STATION: {
                HvdcConverterStation hvdcConverterStation = (HvdcConverterStation)identifiable;
                if (hvdcConverterStation.getHvdcType() != HvdcConverterStation.HvdcType.VSC) break;
                VscConverterStation vscConverterStation = (VscConverterStation)hvdcConverterStation;
                RegulatedTerminalControllers.add(regulatedTerminals, vscConverterStation.getRegulatingTerminal());
                break;
            }
            case LINE_COMMUTATED_CONVERTER: 
            case VOLTAGE_SOURCE_CONVERTER: {
                AcDcConverter acDcConverter = (AcDcConverter)identifiable;
                RegulatedTerminalControllers.add(regulatedTerminals, acDcConverter.getPccTerminal());
                break;
            }
        }
        return regulatedTerminals;
    }

    private static void add(List<TerminalRef> regulatedTerminals, Terminal regulatedTerminal) {
        if (regulatedTerminal != null) {
            regulatedTerminals.add(RegulatedTerminalControllers.newTerminalRef(regulatedTerminal));
        }
    }

    private List<TerminalRef> findRegulatedTerminalsInExtensions(Identifiable<?> identifiable) {
        ArrayList<TerminalRef> regulatedTerminals = new ArrayList<TerminalRef>();
        identifiable.getExtensions().stream().map(Extension::getName).forEach(extensionName -> RegulatedTerminalControllers.add(regulatedTerminals, RegulatedTerminalControllers.findRegulatedTerminalInExtension(identifiable, extensionName)));
        return regulatedTerminals;
    }

    private static Terminal findRegulatedTerminalInExtension(Identifiable<?> identifiable, String extensionName) {
        switch (extensionName) {
            case "voltageRegulation": {
                Battery battery = (Battery)identifiable;
                VoltageRegulation voltageRegulation = (VoltageRegulation)battery.getExtension(VoltageRegulation.class);
                return voltageRegulation.getRegulatingTerminal();
            }
            case "generatorRemoteReactivePowerControl": {
                Generator generator = (Generator)identifiable;
                RemoteReactivePowerControl remoteReactivePowerControl = (RemoteReactivePowerControl)generator.getExtension(RemoteReactivePowerControl.class);
                return remoteReactivePowerControl.getRegulatingTerminal();
            }
            case "slackTerminal": {
                VoltageLevel voltageLevel = (VoltageLevel)identifiable;
                SlackTerminal slackTerminal = (SlackTerminal)voltageLevel.getExtension(SlackTerminal.class);
                return slackTerminal.getTerminal();
            }
        }
        return null;
    }

    public boolean usedAsRegulatedTerminal(Terminal regulatedTerminal) {
        Objects.requireNonNull(regulatedTerminal);
        return this.controllers.containsKey(RegulatedTerminalControllers.newTerminalRef(regulatedTerminal));
    }

    public void replaceRegulatedTerminal(Terminal currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        Objects.requireNonNull(currentRegulatedTerminal);
        Objects.requireNonNull(newRegulatedTerminal);
        TerminalRef currentRegulatedTerminalRef = RegulatedTerminalControllers.newTerminalRef(currentRegulatedTerminal);
        if (this.controllers.containsKey(currentRegulatedTerminalRef)) {
            this.controllers.get(currentRegulatedTerminalRef).forEach(identifiable -> RegulatedTerminalControllers.replaceRegulatedTerminal(identifiable, currentRegulatedTerminalRef, newRegulatedTerminal));
        }
    }

    private static void replaceRegulatedTerminal(Identifiable<?> identifiable, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        switch (identifiable.getType()) {
            case TWO_WINDINGS_TRANSFORMER: {
                RegulatedTerminalControllers.replaceRegulatedTerminalTwoWindingsTransformer((TwoWindingsTransformer)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case THREE_WINDINGS_TRANSFORMER: {
                RegulatedTerminalControllers.replaceRegulatedTerminalThreeWindingsTransformer((ThreeWindingsTransformer)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case GENERATOR: {
                RegulatedTerminalControllers.replaceRegulatedTerminalGenerator((Generator)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case SHUNT_COMPENSATOR: {
                RegulatedTerminalControllers.replaceRegulatedTerminalShuntCompensator((ShuntCompensator)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case STATIC_VAR_COMPENSATOR: {
                RegulatedTerminalControllers.replaceRegulatedTerminalStaticVarCompensator((StaticVarCompensator)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case HVDC_CONVERTER_STATION: {
                RegulatedTerminalControllers.replaceRegulatedTerminalHvdcConverterStation((HvdcConverterStation)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case BATTERY: {
                RegulatedTerminalControllers.replaceRegulatedTerminalBattery((Battery)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case VOLTAGE_LEVEL: {
                RegulatedTerminalControllers.replaceRegulatedTerminalVoltageLevel((VoltageLevel)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            case LINE_COMMUTATED_CONVERTER: 
            case VOLTAGE_SOURCE_CONVERTER: {
                RegulatedTerminalControllers.replaceRegulatedTerminalAcDcConverter((AcDcConverter)identifiable, currentRegulatedTerminal, newRegulatedTerminal);
                break;
            }
            default: {
                throw new PowsyblException("unexpected identifiable type: " + String.valueOf(identifiable.getType()));
            }
        }
    }

    private static void replaceRegulatedTerminalTwoWindingsTransformer(TwoWindingsTransformer t2w, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        t2w.getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.replace(rtc, currentRegulatedTerminal, newRegulatedTerminal));
        t2w.getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.replace(ptc, currentRegulatedTerminal, newRegulatedTerminal));
    }

    private static void replaceRegulatedTerminalThreeWindingsTransformer(ThreeWindingsTransformer t3w, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        t3w.getLeg1().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.replace(rtc, currentRegulatedTerminal, newRegulatedTerminal));
        t3w.getLeg1().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.replace(ptc, currentRegulatedTerminal, newRegulatedTerminal));
        t3w.getLeg2().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.replace(rtc, currentRegulatedTerminal, newRegulatedTerminal));
        t3w.getLeg2().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.replace(ptc, currentRegulatedTerminal, newRegulatedTerminal));
        t3w.getLeg3().getOptionalRatioTapChanger().ifPresent(rtc -> RegulatedTerminalControllers.replace(rtc, currentRegulatedTerminal, newRegulatedTerminal));
        t3w.getLeg3().getOptionalPhaseTapChanger().ifPresent(ptc -> RegulatedTerminalControllers.replace(ptc, currentRegulatedTerminal, newRegulatedTerminal));
    }

    private static void replace(TapChanger<?, ?, ?, ?> tc, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        if (tc.getRegulationTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(tc.getRegulationTerminal()))) {
            tc.setRegulationTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalGenerator(Generator generator, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        if (generator.getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(generator.getRegulatingTerminal()))) {
            generator.setRegulatingTerminal(newRegulatedTerminal);
        } else {
            RemoteReactivePowerControl remoteReactivePowerControl = (RemoteReactivePowerControl)generator.getExtension(RemoteReactivePowerControl.class);
            if (remoteReactivePowerControl != null && remoteReactivePowerControl.getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(remoteReactivePowerControl.getRegulatingTerminal()))) {
                remoteReactivePowerControl.setRegulatingTerminal(newRegulatedTerminal);
            }
        }
    }

    private static void replaceRegulatedTerminalShuntCompensator(ShuntCompensator shuntCompensator, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        if (shuntCompensator.getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(shuntCompensator.getRegulatingTerminal()))) {
            shuntCompensator.setRegulatingTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalStaticVarCompensator(StaticVarCompensator staticVarCompensator, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        if (staticVarCompensator.getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(staticVarCompensator.getRegulatingTerminal()))) {
            staticVarCompensator.setRegulatingTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalHvdcConverterStation(HvdcConverterStation<?> hvdcConverterStation, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        VscConverterStation vscConverterStation;
        if (hvdcConverterStation.getHvdcType() == HvdcConverterStation.HvdcType.VSC && (vscConverterStation = (VscConverterStation)hvdcConverterStation).getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(vscConverterStation.getRegulatingTerminal()))) {
            vscConverterStation.setRegulatingTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalAcDcConverter(AcDcConverter<?> acDcConverter, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        if (acDcConverter.getPccTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(acDcConverter.getPccTerminal()))) {
            acDcConverter.setPccTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalBattery(Battery battery, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        VoltageRegulation voltageRegulation = (VoltageRegulation)battery.getExtension(VoltageRegulation.class);
        if (voltageRegulation != null && voltageRegulation.getRegulatingTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(voltageRegulation.getRegulatingTerminal()))) {
            voltageRegulation.setRegulatingTerminal(newRegulatedTerminal);
        }
    }

    private static void replaceRegulatedTerminalVoltageLevel(VoltageLevel voltageLevel, TerminalRef currentRegulatedTerminal, Terminal newRegulatedTerminal) {
        SlackTerminal slackTerminal = (SlackTerminal)voltageLevel.getExtension(SlackTerminal.class);
        if (slackTerminal != null && slackTerminal.getTerminal() != null && currentRegulatedTerminal.equals(RegulatedTerminalControllers.newTerminalRef(slackTerminal.getTerminal()))) {
            slackTerminal.setTerminal(newRegulatedTerminal);
        }
    }

    private static TerminalRef newTerminalRef(Terminal terminal) {
        Objects.requireNonNull(terminal);
        return new TerminalRef(terminal.getConnectable().getId(), terminal.getSide());
    }

    private record TerminalRef(String identifiableId, ThreeSides side) {
    }
}

