/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.scripting;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.ImportPostProcessor;
import com.powsybl.iidm.network.Network;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.transform.ThreadInterrupt;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ImportPostProcessor.class})
public class GroovyScriptPostProcessor
implements ImportPostProcessor {
    public static final String NAME = "groovyScript";
    public static final String DEFAULT_SCRIPT_NAME = "import-post-processor.groovy";
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptPostProcessor.class);
    private final Path script;

    public GroovyScriptPostProcessor() {
        this(PlatformConfig.defaultConfig());
    }

    public GroovyScriptPostProcessor(PlatformConfig platformConfig) {
        this(GroovyScriptPostProcessor.getConfiguredScript(platformConfig));
    }

    public GroovyScriptPostProcessor(Path script) {
        this.script = Objects.requireNonNull(script);
    }

    private static Path getConfiguredScript(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        return (Path)platformConfig.getOptionalModuleConfig("groovy-post-processor").flatMap(config -> config.getOptionalPathProperty("script")).or(() -> platformConfig.getConfigDir().map(dir -> dir.resolve(DEFAULT_SCRIPT_NAME))).orElseThrow(() -> new PowsyblException("No script path nor configuration directory defined in platform config"));
    }

    public String getName() {
        return NAME;
    }

    public void process(Network network, ComputationManager computationManager) throws Exception {
        if (Files.exists(this.script, new LinkOption[0])) {
            LOGGER.debug("Execute groovy post processor {}", (Object)this.script);
            try (BufferedReader reader = Files.newBufferedReader(this.script, StandardCharsets.UTF_8);){
                CompilerConfiguration conf = new CompilerConfiguration();
                conf.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(ThreadInterrupt.class)});
                Binding binding = new Binding();
                binding.setVariable("network", (Object)network);
                binding.setVariable("computationManager", (Object)computationManager);
                GroovyShell shell = new GroovyShell(binding, conf);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Execution Interrupted");
                }
                shell.evaluate((Reader)reader);
            }
        }
    }
}

