/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.serde.AbstractIdentifiableSerDe;
import com.powsybl.iidm.serde.AliasesSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.PropertiesSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

abstract class AbstractComplexIdentifiableSerDe<T extends Identifiable<T>, A extends IdentifiableAdder<T, A>, P extends Identifiable>
extends AbstractIdentifiableSerDe<T, A, P> {
    AbstractComplexIdentifiableSerDe() {
    }

    protected abstract void readRootElementAttributes(A var1, List<Consumer<T>> var2, NetworkDeserializerContext var3);

    protected void readSubElement(String elementName, String id, List<Consumer<T>> toApply, NetworkDeserializerContext context) {
        switch (elementName) {
            case "property": {
                PropertiesSerDe.read(toApply, context);
                break;
            }
            case "alias": {
                IidmSerDeUtil.assertMinimumVersion(this.getRootElementName(), "alias", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_3, context);
                AliasesSerDe.read(toApply, context);
                break;
            }
            default: {
                throw new PowsyblException("Unknown element name '" + elementName + "' in '" + id + "'");
            }
        }
    }

    protected abstract void readSubElements(String var1, A var2, List<Consumer<T>> var3, NetworkDeserializerContext var4);

    @Override
    public final void read(P parent, NetworkDeserializerContext context) {
        ArrayList<Consumer<Consumer>> toApply = new ArrayList<Consumer<Consumer>>();
        Object adder = this.createAdder(parent);
        String id = this.readIdentifierAttributes(adder, context);
        this.readRootElementAttributes(adder, toApply, context);
        this.readSubElements(id, adder, toApply, context);
        Identifiable identifiable = adder.add();
        toApply.forEach(consumer -> consumer.accept(identifiable));
    }
}

