/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.serde.AliasesSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.PropertiesSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

abstract class AbstractIdentifiableSerDe<T extends Identifiable<? super T>, A extends IdentifiableAdder<T, A>, P extends Identifiable> {
    AbstractIdentifiableSerDe() {
    }

    protected abstract String getRootElementName();

    protected boolean isValid(T identifiable, P parent) {
        return true;
    }

    protected abstract void writeRootElementAttributes(T var1, P var2, NetworkSerializerContext var3);

    protected void writeSubElements(T identifiable, P parent, NetworkSerializerContext context) {
    }

    public final void write(T identifiable, P parent, NetworkSerializerContext context) {
        if (!this.isValid(identifiable, parent)) {
            return;
        }
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), this.getRootElementName());
        context.getWriter().writeStringAttribute("id", context.getAnonymizer().anonymizeString(identifiable.getId()));
        identifiable.getOptionalName().ifPresent(name -> context.getWriter().writeStringAttribute("name", context.getAnonymizer().anonymizeString((String)name)));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> context.getWriter().writeBooleanAttribute("fictitious", identifiable.isFictitious(), false));
        this.writeRootElementAttributes(identifiable, parent, context);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> AliasesSerDe.write(identifiable, this.getRootElementName(), context));
        PropertiesSerDe.write(identifiable, context);
        this.writeSubElements(identifiable, parent, context);
        context.getWriter().writeEndNode();
        context.addExportedEquipment((Identifiable<?>)identifiable);
    }

    protected abstract A createAdder(P var1);

    public abstract void read(P var1, NetworkDeserializerContext var2);

    protected String readIdentifierAttributes(A adder, NetworkDeserializerContext context) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("id"));
        String name = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("name"));
        adder.setId(id).setName(name);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> {
            boolean fictitious = context.getReader().readBooleanAttribute("fictitious", false);
            adder.setFictitious(fictitious);
        });
        return id;
    }
}

