/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.TapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.function.DoubleConsumer;

abstract class AbstractTransformerSerDe<T extends Connectable<T>, A extends IdentifiableAdder<T, A>>
extends AbstractSimpleIdentifiableSerDe<T, A, Substation> {
    private static final String ATTR_LOW_TAP_POSITION = "lowTapPosition";
    private static final String ATTR_TAP_POSITION = "tapPosition";
    private static final String ATTR_REGULATING = "regulating";
    private static final String ELEM_TERMINAL_REF = "terminalRef";
    static final String STEP_ROOT_ELEMENT_NAME = "step";
    static final String STEP_ARRAY_ELEMENT_NAME = "steps";
    private static final String TARGET_DEADBAND = "targetDeadband";
    private static final String RATIO_TAP_CHANGER = "ratioTapChanger";
    private static final String PHASE_TAP_CHANGER = "phaseTapChanger";

    AbstractTransformerSerDe() {
    }

    protected static void writeTapChangerStep(TapChangerStep<?> tcs, TreeDataWriter writer) {
        writer.writeDoubleAttribute("r", tcs.getR());
        writer.writeDoubleAttribute("x", tcs.getX());
        writer.writeDoubleAttribute("g", tcs.getG());
        writer.writeDoubleAttribute("b", tcs.getB());
        writer.writeDoubleAttribute("rho", tcs.getRho());
    }

    private static void writeTargetDeadband(double targetDeadband, NetworkSerializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> context.getWriter().writeDoubleAttribute(TARGET_DEADBAND, targetDeadband, 0.0));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> context.getWriter().writeDoubleAttribute(TARGET_DEADBAND, targetDeadband));
    }

    private static double readTargetDeadband(NetworkDeserializerContext context, boolean regulating) {
        double[] targetDeadband = new double[1];
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> {
            targetDeadband[0] = context.getReader().readDoubleAttribute(TARGET_DEADBAND);
            if (regulating && Double.isNaN(targetDeadband[0])) {
                targetDeadband[0] = 0.0;
            }
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> {
            targetDeadband[0] = context.getReader().readDoubleAttribute(TARGET_DEADBAND);
        });
        return targetDeadband[0];
    }

    private static void writeTapChanger(TapChanger<?, ?> tc, NetworkSerializerContext context) {
        context.getWriter().writeIntAttribute(ATTR_LOW_TAP_POSITION, tc.getLowTapPosition());
        if (tc.findTapPosition().isPresent()) {
            context.getWriter().writeIntAttribute(ATTR_TAP_POSITION, tc.getTapPosition());
        }
        AbstractTransformerSerDe.writeTargetDeadband(tc.getTargetDeadband(), context);
    }

    protected static void writeRatioTapChanger(String name, RatioTapChanger rtc, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), name);
        if (rtc.hasLoadTapChangingCapabilities() || rtc.isRegulating()) {
            context.getWriter().writeBooleanAttribute(ATTR_REGULATING, rtc.isRegulating());
        }
        AbstractTransformerSerDe.writeTapChanger(rtc, context);
        context.getWriter().writeBooleanAttribute("loadTapChangingCapabilities", rtc.hasLoadTapChangingCapabilities());
        context.getWriter().writeDoubleAttribute("targetV", rtc.getTargetV());
        if (rtc.getRegulationTerminal() != null) {
            TerminalRefSerDe.writeTerminalRef(rtc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        }
        context.getWriter().writeStartNodes();
        for (int p = rtc.getLowTapPosition(); p <= rtc.getHighTapPosition(); ++p) {
            RatioTapChangerStep rtcs = (RatioTapChangerStep)rtc.getStep(p);
            context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), STEP_ROOT_ELEMENT_NAME);
            AbstractTransformerSerDe.writeTapChangerStep(rtcs, context.getWriter());
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    protected static void readRatioTapChanger(String elementName, RatioTapChangerAdder adder, Terminal terminal, NetworkDeserializerContext context) {
        boolean regulating = context.getReader().readBooleanAttribute(ATTR_REGULATING, false);
        int lowTapPosition = context.getReader().readIntAttribute(ATTR_LOW_TAP_POSITION);
        Integer tapPosition = context.getReader().readIntAttribute(ATTR_TAP_POSITION);
        double targetDeadband = AbstractTransformerSerDe.readTargetDeadband(context, regulating);
        boolean loadTapChangingCapabilities = context.getReader().readBooleanAttribute("loadTapChangingCapabilities");
        double targetV = context.getReader().readDoubleAttribute("targetV");
        adder.setLowTapPosition(lowTapPosition).setTargetDeadband(targetDeadband).setLoadTapChangingCapabilities(loadTapChangingCapabilities).setTargetV(targetV).setRegulating(regulating);
        if (tapPosition != null) {
            adder.setTapPosition(tapPosition.intValue());
        }
        boolean[] hasTerminalRef = new boolean[1];
        context.getReader().readChildNodes(subElementName -> {
            switch (subElementName) {
                case "terminalRef": {
                    hasTerminalRef[0] = true;
                    TerminalRefSerDe.readTerminalRef(context, terminal.getVoltageLevel().getNetwork(), tRef -> {
                        adder.setRegulationTerminal(tRef);
                        adder.add();
                    });
                    break;
                }
                case "step": {
                    AbstractTransformerSerDe.readSteps(context, (r, x, g, b, rho) -> adder.beginStep().setR(r).setX(x).setG(g).setB(b).setRho(rho).endStep());
                    context.getReader().readEndNode();
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + subElementName + "' in '" + elementName + "'");
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    protected static void readRatioTapChanger(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readRatioTapChanger(RATIO_TAP_CHANGER, twt.newRatioTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readRatioTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readRatioTapChanger(RATIO_TAP_CHANGER + leg, twl.newRatioTapChanger(), twl.getTerminal(), context);
    }

    protected static void writePhaseTapChanger(String name, PhaseTapChanger ptc, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), name);
        if (ptc.getRegulationMode() != null && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP || ptc.isRegulating()) {
            context.getWriter().writeBooleanAttribute(ATTR_REGULATING, ptc.isRegulating());
        }
        AbstractTransformerSerDe.writeTapChanger(ptc, context);
        context.getWriter().writeEnumAttribute("regulationMode", (Enum)ptc.getRegulationMode());
        if (ptc.getRegulationMode() != null && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP || !Double.isNaN(ptc.getRegulationValue())) {
            context.getWriter().writeDoubleAttribute("regulationValue", ptc.getRegulationValue());
        }
        if (ptc.getRegulationTerminal() != null) {
            TerminalRefSerDe.writeTerminalRef(ptc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        }
        context.getWriter().writeStartNodes();
        for (int p = ptc.getLowTapPosition(); p <= ptc.getHighTapPosition(); ++p) {
            PhaseTapChangerStep ptcs = (PhaseTapChangerStep)ptc.getStep(p);
            context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), STEP_ROOT_ELEMENT_NAME);
            AbstractTransformerSerDe.writeTapChangerStep(ptcs, context.getWriter());
            context.getWriter().writeDoubleAttribute("alpha", ptcs.getAlpha());
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    protected static void readPhaseTapChanger(String name, PhaseTapChangerAdder adder, Terminal terminal, NetworkDeserializerContext context) {
        boolean regulating = context.getReader().readBooleanAttribute(ATTR_REGULATING, false);
        int lowTapPosition = context.getReader().readIntAttribute(ATTR_LOW_TAP_POSITION);
        Integer tapPosition = context.getReader().readIntAttribute(ATTR_TAP_POSITION);
        double targetDeadband = AbstractTransformerSerDe.readTargetDeadband(context, regulating);
        PhaseTapChanger.RegulationMode regulationMode = (PhaseTapChanger.RegulationMode)context.getReader().readEnumAttribute("regulationMode", PhaseTapChanger.RegulationMode.class);
        double regulationValue = context.getReader().readDoubleAttribute("regulationValue");
        adder.setLowTapPosition(lowTapPosition).setTargetDeadband(targetDeadband).setRegulationMode(regulationMode).setRegulationValue(regulationValue).setRegulating(regulating);
        if (tapPosition != null) {
            adder.setTapPosition(tapPosition.intValue());
        }
        boolean[] hasTerminalRef = new boolean[1];
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "terminalRef": {
                    hasTerminalRef[0] = true;
                    TerminalRefSerDe.readTerminalRef(context, terminal.getVoltageLevel().getNetwork(), tRef -> {
                        adder.setRegulationTerminal(tRef);
                        adder.add();
                    });
                    break;
                }
                case "step": {
                    PhaseTapChangerAdder.StepAdder stepAdder = adder.beginStep();
                    AbstractTransformerSerDe.readSteps(context, (r, x, g, b, rho) -> stepAdder.setR(r).setX(x).setG(g).setB(b).setRho(rho));
                    double alpha = context.getReader().readDoubleAttribute("alpha");
                    context.getReader().readEndNode();
                    stepAdder.setAlpha(alpha).endStep();
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in '" + name + "'");
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    protected static void readPhaseTapChanger(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readPhaseTapChanger(PHASE_TAP_CHANGER, twt.newPhaseTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readPhaseTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readPhaseTapChanger(PHASE_TAP_CHANGER + leg, twl.newPhaseTapChanger(), twl.getTerminal(), context);
    }

    private static void readSteps(NetworkDeserializerContext context, StepConsumer consumer) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g = context.getReader().readDoubleAttribute("g");
        double b = context.getReader().readDoubleAttribute("b");
        double rho = context.getReader().readDoubleAttribute("rho");
        consumer.accept(r, x, g, b, rho);
    }

    protected static void readRatedS(String name, NetworkDeserializerContext context, DoubleConsumer consumer) {
        double ratedS = context.getReader().readDoubleAttribute(name);
        consumer.accept(ratedS);
    }

    protected static void writeRatedS(String name, double ratedS, NetworkSerializerContext context) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> context.getWriter().writeDoubleAttribute(name, ratedS));
    }

    private static interface StepConsumer {
        public void accept(double var1, double var3, double var5, double var7, double var9);
    }
}

