/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.List;
import java.util.function.Consumer;

public final class AliasesSerDe {
    static final String ARRAY_ELEMENT_NAME = "aliases";
    static final String ROOT_ELEMENT_NAME = "alias";

    public static void write(Identifiable<?> identifiable, String rootElementName, NetworkSerializerContext context) {
        IidmSerDeUtil.assertMinimumVersionIfNotDefault(!identifiable.getAliases().isEmpty(), rootElementName, ROOT_ELEMENT_NAME, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_3, context);
        context.getWriter().writeStartNodes();
        for (String alias : identifiable.getAliases()) {
            context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), ROOT_ELEMENT_NAME);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_4, context, () -> identifiable.getAliasType(alias).ifPresent(type -> context.getWriter().writeStringAttribute("type", type)));
            context.getWriter().writeNodeContent(context.getAnonymizer().anonymizeString(alias));
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
    }

    public static <T extends Identifiable> void read(T identifiable, NetworkDeserializerContext context) {
        AliasesSerDe.read(context).accept(identifiable);
    }

    public static <T extends Identifiable> void read(List<Consumer<T>> toApply, NetworkDeserializerContext context) {
        toApply.add(AliasesSerDe.read(context));
    }

    private static <T extends Identifiable> Consumer<T> read(NetworkDeserializerContext context) {
        String[] aliasType = new String[1];
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_4, context, () -> {
            aliasType[0] = context.getReader().readStringAttribute("type");
        });
        String alias = context.getAnonymizer().deanonymizeString(context.getReader().readContent());
        return identifiable -> identifiable.addAlias(alias, aliasType[0]);
    }

    private AliasesSerDe() {
    }
}

