/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSwitchSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusBreakerViewSwitchSerDe
extends AbstractSwitchSerDe<VoltageLevel.BusBreakerView.SwitchAdder> {
    static final BusBreakerViewSwitchSerDe INSTANCE = new BusBreakerViewSwitchSerDe();
    private static final Logger LOGGER = LoggerFactory.getLogger(BusBreakerViewSwitchSerDe.class);

    @Override
    protected boolean isValid(Switch s, VoltageLevel vl) {
        VoltageLevel.BusBreakerView v = vl.getBusBreakerView();
        if (v.getBus1(s.getId()).getId().equals(v.getBus2(s.getId()).getId())) {
            LOGGER.warn("Discard switch with same bus at both ends. Id: {}", (Object)s.getId());
            return false;
        }
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Switch s, VoltageLevel vl, NetworkSerializerContext context) {
        super.writeRootElementAttributes(s, vl, context);
        VoltageLevel.BusBreakerView v = vl.getBusBreakerView();
        Bus bus1 = v.getBus1(s.getId());
        Bus bus2 = v.getBus2(s.getId());
        context.getWriter().writeStringAttribute("bus1", context.getAnonymizer().anonymizeString(bus1.getId()));
        context.getWriter().writeStringAttribute("bus2", context.getAnonymizer().anonymizeString(bus2.getId()));
    }

    @Override
    protected VoltageLevel.BusBreakerView.SwitchAdder createAdder(VoltageLevel vl) {
        return vl.getBusBreakerView().newSwitch();
    }

    @Override
    protected Switch readRootElementAttributes(VoltageLevel.BusBreakerView.SwitchAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        context.getReader().readEnumAttribute("kind", SwitchKind.class);
        context.getReader().readBooleanAttribute("retained");
        boolean open = context.getReader().readBooleanAttribute("open");
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> {
            boolean fictitious = context.getReader().readBooleanAttribute("fictitious", false);
            adder.setFictitious(fictitious);
        });
        String bus1 = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("bus1"));
        String bus2 = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("bus2"));
        if (bus1.equals(bus2) && context.getVersion().compareTo(IidmVersion.V_1_8) < 0) {
            LOGGER.warn("Discard switch with same bus {} at both ends", (Object)bus1);
            return null;
        }
        return adder.setOpen(open).setBus1(bus1).setBus2(bus2).add();
    }
}

