/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.auto.service.AutoService;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.io.TreeDataFormat;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.serde.AbstractTreeDataImporter;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.ImportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@AutoService(value={Importer.class})
public class JsonImporter
extends AbstractTreeDataImporter {
    private static final String[] EXTENSIONS = new String[]{"jiidm", "json", "iidm.json"};

    @Override
    protected String[] getExtensions() {
        return EXTENSIONS;
    }

    public String getFormat() {
        return "JIIDM";
    }

    public String getComment() {
        return "IIDM JSON v " + IidmSerDeConstants.CURRENT_IIDM_VERSION.toString(".") + " importer";
    }

    @Override
    protected boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        if (ext != null) {
            try (InputStream is = dataSource.newInputStream(null, ext);){
                boolean bl;
                block17: {
                    JsonParser parser;
                    block15: {
                        boolean bl2;
                        block16: {
                            parser = JsonUtil.createJsonFactory().createParser(is);
                            try {
                                if (parser.nextToken() == JsonToken.START_OBJECT) break block15;
                                bl2 = false;
                                if (parser == null) break block16;
                            }
                            catch (Throwable throwable) {
                                if (parser != null) {
                                    try {
                                        parser.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            parser.close();
                        }
                        return bl2;
                    }
                    bl = "version".equals(parser.nextFieldName());
                    if (parser == null) break block17;
                    parser.close();
                }
                return bl;
            }
        }
        return false;
    }

    @Override
    protected ImportOptions createImportOptions(Properties parameters) {
        return (ImportOptions)super.createImportOptions(parameters).setFormat(TreeDataFormat.JSON);
    }
}

