/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Optional;

class LineSerDe
extends AbstractSimpleIdentifiableSerDe<Line, LineAdder, Network> {
    static final LineSerDe INSTANCE = new LineSerDe();
    static final String ROOT_ELEMENT_NAME = "line";
    static final String ARRAY_ELEMENT_NAME = "lines";

    LineSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Line l, Network n, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("r", l.getR());
        context.getWriter().writeDoubleAttribute("x", l.getX());
        context.getWriter().writeDoubleAttribute("g1", l.getG1());
        context.getWriter().writeDoubleAttribute("b1", l.getB1());
        context.getWriter().writeDoubleAttribute("g2", l.getG2());
        context.getWriter().writeDoubleAttribute("b2", l.getB2());
        ConnectableSerDeUtil.writeNodeOrBus(1, l.getTerminal1(), context);
        ConnectableSerDeUtil.writeNodeOrBus(2, l.getTerminal2(), context);
        if (context.getOptions().isWithBranchSV()) {
            ConnectableSerDeUtil.writePQ(1, l.getTerminal1(), context.getWriter());
            ConnectableSerDeUtil.writePQ(2, l.getTerminal2(), context.getWriter());
        }
    }

    @Override
    protected void writeSubElements(Line l, Network n, NetworkSerializerContext context) {
        Optional apparentPowerLimits2;
        Optional apparentPowerLimits1;
        Optional activePowerLimits1 = l.getActivePowerLimits1();
        if (activePowerLimits1.isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits1 = l.getApparentPowerLimits1()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        Optional currentLimits1 = l.getCurrentLimits1();
        currentLimits1.ifPresent(currentLimits -> ConnectableSerDeUtil.writeCurrentLimits((Integer)1, currentLimits, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        Optional activePowerLimits2 = l.getActivePowerLimits2();
        if (activePowerLimits2.isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits2 = l.getApparentPowerLimits2()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        Optional currentLimits2 = l.getCurrentLimits2();
        currentLimits2.ifPresent(currentLimits -> ConnectableSerDeUtil.writeCurrentLimits((Integer)2, currentLimits, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
    }

    @Override
    protected LineAdder createAdder(Network n) {
        return n.newLine();
    }

    @Override
    protected Line readRootElementAttributes(LineAdder adder, Network network, NetworkDeserializerContext context) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g1 = context.getReader().readDoubleAttribute("g1");
        double b1 = context.getReader().readDoubleAttribute("b1");
        double g2 = context.getReader().readDoubleAttribute("g2");
        double b2 = context.getReader().readDoubleAttribute("b2");
        adder.setR(r).setX(x).setG1(g1).setB1(b1).setG2(g2).setB2(b2);
        ConnectableSerDeUtil.readNodeOrBus(adder, context);
        Line l = adder.add();
        ConnectableSerDeUtil.readPQ(1, l.getTerminal1(), context.getReader());
        ConnectableSerDeUtil.readPQ(2, l.getTerminal2(), context.getReader());
        return l;
    }

    @Override
    protected void readSubElements(Line l, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(l.newActivePowerLimits1(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(l.newApparentPowerLimits1(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    ConnectableSerDeUtil.readCurrentLimits(l.newCurrentLimits1(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(l.newActivePowerLimits2(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(l.newApparentPowerLimits2(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    ConnectableSerDeUtil.readCurrentLimits(l.newCurrentLimits2(), context.getReader());
                    break;
                }
                default: {
                    super.readSubElement(elementName, l, context);
                }
            }
        });
    }
}

