/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.ThreeWindingsTransformerSerDe;
import com.powsybl.iidm.serde.TwoWindingsTransformerSerDe;
import com.powsybl.iidm.serde.VoltageLevelSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Optional;

class SubstationSerDe
extends AbstractSimpleIdentifiableSerDe<Substation, SubstationAdder, Network> {
    static final SubstationSerDe INSTANCE = new SubstationSerDe();
    static final String ROOT_ELEMENT_NAME = "substation";
    static final String ARRAY_ELEMENT_NAME = "substations";
    private static final String COUNTRY = "country";

    SubstationSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Substation s, Network n, NetworkSerializerContext context) {
        Optional country = s.getCountry();
        country.ifPresent(value -> context.getWriter().writeStringAttribute(COUNTRY, context.getAnonymizer().anonymizeCountry((Country)value).toString()));
        if (s.getTso() != null) {
            context.getWriter().writeStringAttribute("tso", context.getAnonymizer().anonymizeString(s.getTso()));
        }
        if (!s.getGeographicalTags().isEmpty()) {
            context.getWriter().writeStringArrayAttribute("geographicalTags", s.getGeographicalTags().stream().map(tag -> context.getAnonymizer().anonymizeString((String)tag)).toList());
        }
    }

    @Override
    protected void writeSubElements(Substation s, Network n, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Object vl : IidmSerDeUtil.sorted(s.getVoltageLevels(), context.getOptions())) {
            VoltageLevelSerDe.INSTANCE.write(vl, null, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeStartNodes();
        Iterable<TwoWindingsTransformer> twts = IidmSerDeUtil.sorted(s.getTwoWindingsTransformers(), context.getOptions());
        for (TwoWindingsTransformer twt : twts) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            TwoWindingsTransformerSerDe.INSTANCE.write(twt, null, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeStartNodes();
        Iterable<ThreeWindingsTransformer> twts2 = IidmSerDeUtil.sorted(s.getThreeWindingsTransformers(), context.getOptions());
        for (ThreeWindingsTransformer twt : twts2) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            ThreeWindingsTransformerSerDe.INSTANCE.write(twt, null, context);
        }
        context.getWriter().writeEndNodes();
    }

    @Override
    protected SubstationAdder createAdder(Network network) {
        return network.newSubstation();
    }

    @Override
    protected Substation readRootElementAttributes(SubstationAdder adder, Network network, NetworkDeserializerContext context) {
        Country country = Optional.ofNullable(context.getReader().readStringAttribute(COUNTRY)).map(c -> context.getAnonymizer().deanonymizeCountry(Country.valueOf((String)c))).orElse(null);
        String tso = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("tso"));
        String[] geographicalTags = (String[])context.getReader().readStringArrayAttribute("geographicalTags").stream().map(tag -> context.getAnonymizer().deanonymizeString((String)tag)).toArray(String[]::new);
        return adder.setCountry(country).setTso(tso).setGeographicalTags(geographicalTags).add();
    }

    @Override
    protected void readSubElements(Substation s, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "voltageLevel": {
                    VoltageLevelSerDe.INSTANCE.read(s, context);
                    break;
                }
                case "twoWindingsTransformer": {
                    TwoWindingsTransformerSerDe.INSTANCE.read(s, context);
                    break;
                }
                case "threeWindingsTransformer": {
                    ThreeWindingsTransformerSerDe.INSTANCE.read(s, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, s, context);
                }
            }
        });
    }
}

