/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.function.Consumer;

public final class TerminalRefSerDe {
    private static final String ID = "id";
    private static final String SIDE = "side";

    public static void writeTerminalRef(Terminal t, NetworkSerializerContext context, String elementName) {
        TerminalRefSerDe.writeTerminalRef(t, context, context.getVersion().getNamespaceURI(context.isValid()), elementName);
    }

    public static void writeTerminalRef(Terminal t, NetworkSerializerContext context, String namespace, String elementName) {
        TerminalRefSerDe.writeTerminalRef(t, context, namespace, elementName, context.getWriter());
    }

    public static void writeTerminalRef(Terminal t, NetworkSerializerContext context, String namespace, String elementName, TreeDataWriter writer) {
        writer.writeStartNode(namespace, elementName);
        TerminalRefSerDe.writeTerminalRefAttribute(t, context, writer);
        writer.writeEndNode();
    }

    public static void writeTerminalRefAttribute(Terminal t, NetworkSerializerContext context) {
        TerminalRefSerDe.writeTerminalRefAttribute(t, context, context.getWriter());
    }

    public static void writeTerminalRefAttribute(Terminal t, NetworkSerializerContext context, TreeDataWriter writer) {
        Connectable c = t.getConnectable();
        if (!context.getFilter().test(c)) {
            throw new PowsyblException("Oups, terminal ref point to a filtered equipment " + c.getId());
        }
        if (t.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER && context.getOptions().getTopologyLevel() != TopologyLevel.NODE_BREAKER && t.getConnectable() instanceof BusbarSection) {
            throw new PowsyblException(String.format("Terminal ref should not point to a busbar section (here %s). Try to export in node-breaker or delete this terminal ref.", t.getConnectable().getId()));
        }
        writer.writeStringAttribute(ID, context.getAnonymizer().anonymizeString(c.getId()));
        Terminal.getConnectableSide((Terminal)t).ifPresent(side -> writer.writeStringAttribute(SIDE, side.name()));
    }

    public static Terminal readTerminal(NetworkDeserializerContext context, Network n) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(ID));
        String side = context.getReader().readStringAttribute(SIDE);
        context.getReader().readEndNode();
        return TerminalRefSerDe.resolve(id, side, n);
    }

    public static void readTerminalRef(NetworkDeserializerContext context, Network network, Consumer<Terminal> endTaskTerminalConsumer) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(ID));
        String side = context.getReader().readStringAttribute(SIDE);
        context.getReader().readEndNode();
        context.getEndTasks().add(() -> {
            Terminal t = TerminalRefSerDe.resolve(id, side, network);
            endTaskTerminalConsumer.accept(t);
        });
    }

    public static Terminal resolve(String id, String sideText, Network network) {
        ThreeSides side = sideText == null ? ThreeSides.ONE : ThreeSides.valueOf((String)sideText);
        return TerminalRefSerDe.resolve(id, side, network);
    }

    public static Terminal resolve(String id, ThreeSides side, Network network) {
        Identifiable identifiable = network.getIdentifiable(id);
        if (identifiable == null) {
            throw new PowsyblException("Terminal reference identifiable not found: '" + id + "'");
        }
        return Terminal.getTerminal((Identifiable)identifiable, (ThreeSides)side);
    }

    private TerminalRefSerDe() {
    }
}

