/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TieLineSerDe
extends AbstractSimpleIdentifiableSerDe<TieLine, TieLineAdder, Network> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieLineSerDe.class);
    static final TieLineSerDe INSTANCE = new TieLineSerDe();
    static final String ROOT_ELEMENT_NAME = "tieLine";
    static final String ARRAY_ELEMENT_NAME = "tieLines";

    TieLineSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    private static void writeDanglingLine(DanglingLine danglingLine, NetworkSerializerContext context, int side) {
        Boundary boundary = danglingLine.getBoundary();
        context.getWriter().writeStringAttribute("id_" + side, context.getAnonymizer().anonymizeString(danglingLine.getId()));
        danglingLine.getOptionalName().ifPresent(name -> context.getWriter().writeStringAttribute("name_" + side, context.getAnonymizer().anonymizeString((String)name)));
        context.getWriter().writeDoubleAttribute("r_" + side, danglingLine.getR());
        context.getWriter().writeDoubleAttribute("x_" + side, danglingLine.getX());
        context.getWriter().writeDoubleAttribute("g1_" + side, danglingLine.getG() / 2.0);
        context.getWriter().writeDoubleAttribute("b1_" + side, danglingLine.getB() / 2.0);
        context.getWriter().writeDoubleAttribute("g2_" + side, danglingLine.getG() / 2.0);
        context.getWriter().writeDoubleAttribute("b2_" + side, danglingLine.getB() / 2.0);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            context.getWriter().writeDoubleAttribute("xnodeP_" + side, boundary.getP());
            context.getWriter().writeDoubleAttribute("xnodeQ_" + side, boundary.getQ());
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> context.getWriter().writeBooleanAttribute("fictitious_" + side, danglingLine.isFictitious(), false));
    }

    @Override
    protected void writeRootElementAttributes(TieLine tl, Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_10, context, () -> {
            context.getWriter().writeStringAttribute("danglingLineId1", context.getAnonymizer().anonymizeString(tl.getDanglingLine1().getId()));
            context.getWriter().writeStringAttribute("danglingLineId2", context.getAnonymizer().anonymizeString(tl.getDanglingLine2().getId()));
        });
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            if (tl.getPairingKey() != null) {
                context.getWriter().writeStringAttribute("ucteXnodeCode", tl.getPairingKey());
            }
            ConnectableSerDeUtil.writeNodeOrBus(1, tl.getDanglingLine1().getTerminal(), context);
            ConnectableSerDeUtil.writeNodeOrBus(2, tl.getDanglingLine2().getTerminal(), context);
            if (context.getOptions().isWithBranchSV()) {
                ConnectableSerDeUtil.writePQ(1, tl.getDanglingLine1().getTerminal(), context.getWriter());
                ConnectableSerDeUtil.writePQ(2, tl.getDanglingLine2().getTerminal(), context.getWriter());
            }
            TieLineSerDe.writeDanglingLine(tl.getDanglingLine1(), context, 1);
            TieLineSerDe.writeDanglingLine(tl.getDanglingLine2(), context, 2);
        });
    }

    @Override
    protected void writeSubElements(TieLine tl, Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            Optional currentLimits2;
            Optional apparentPowerLimits2;
            Optional activePowerLimits2;
            Optional currentLimits1;
            Optional apparentPowerLimits1;
            Optional activePowerLimits1 = tl.getDanglingLine1().getActivePowerLimits();
            if (activePowerLimits1.isPresent()) {
                IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
                IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((apparentPowerLimits1 = tl.getDanglingLine1().getApparentPowerLimits()).isPresent()) {
                IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
                IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((currentLimits1 = tl.getDanglingLine1().getCurrentLimits()).isPresent()) {
                ConnectableSerDeUtil.writeCurrentLimits((Integer)1, (CurrentLimits)currentLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
            }
            if ((activePowerLimits2 = tl.getDanglingLine2().getActivePowerLimits()).isPresent()) {
                IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
                IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((apparentPowerLimits2 = tl.getDanglingLine2().getApparentPowerLimits()).isPresent()) {
                IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
                IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((currentLimits2 = tl.getDanglingLine2().getCurrentLimits()).isPresent()) {
                ConnectableSerDeUtil.writeCurrentLimits((Integer)2, (CurrentLimits)currentLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
            }
        });
    }

    @Override
    protected TieLineAdder createAdder(Network n) {
        return n.newTieLine();
    }

    private static DanglingLine readDanglingLine(DanglingLineAdder adder, String pairingKey, NetworkDeserializerContext context, int side) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("id_" + side));
        String name = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("name_" + side));
        double r = context.getReader().readDoubleAttribute("r_" + side);
        double x = context.getReader().readDoubleAttribute("x_" + side);
        double g1 = context.getReader().readDoubleAttribute("g1_" + side);
        double b1 = context.getReader().readDoubleAttribute("b1_" + side);
        double g2 = context.getReader().readDoubleAttribute("g2_" + side);
        double b2 = context.getReader().readDoubleAttribute("b2_" + side);
        ((DanglingLineAdder)((DanglingLineAdder)adder.setId(id)).setName(name)).setPairingKey(pairingKey).setR(r).setX(x).setG(g1 + g2).setB(b1 + b2).setP0(0.0).setQ0(0.0);
        double[] halfBoundaryP = new double[1];
        double[] halfBoundaryQ = new double[1];
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            halfBoundaryP[0] = context.getReader().readDoubleAttribute("xnodeP_" + side);
            halfBoundaryQ[0] = context.getReader().readDoubleAttribute("xnodeQ_" + side);
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> {
            boolean fictitious = context.getReader().readBooleanAttribute("fictitious_" + side, false);
            adder.setFictitious(fictitious);
        });
        DanglingLine dl = adder.add();
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            TieLineSerDe.checkBoundaryValue(halfBoundaryP[0], dl.getBoundary().getP(), "xnodeP_" + side, pairingKey);
            TieLineSerDe.checkBoundaryValue(halfBoundaryQ[0], dl.getBoundary().getQ(), "xnodeQ_" + side, pairingKey);
        });
        return dl;
    }

    @Override
    protected TieLine readRootElementAttributes(TieLineAdder adder, Network network, NetworkDeserializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            String pairingKey = context.getReader().readStringAttribute("ucteXnodeCode");
            DanglingLineAdder adderDl1 = TieLineSerDe.readVlAndNodeOrBus(context, network, 1);
            DanglingLineAdder adderDl2 = TieLineSerDe.readVlAndNodeOrBus(context, network, 2);
            double p1 = context.getReader().readDoubleAttribute("p1");
            double q1 = context.getReader().readDoubleAttribute("q1");
            double p2 = context.getReader().readDoubleAttribute("p2");
            double q2 = context.getReader().readDoubleAttribute("q2");
            DanglingLine dl1 = TieLineSerDe.readDanglingLine(adderDl1, pairingKey, context, 1);
            DanglingLine dl2 = TieLineSerDe.readDanglingLine(adderDl2, pairingKey, context, 2);
            dl1.getTerminal().setP(p1).setQ(q1);
            dl2.getTerminal().setP(p2).setQ(q2);
            adder.setDanglingLine1(dl1.getId()).setDanglingLine2(dl2.getId());
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_10, context, () -> {
            String dl1Id = context.getReader().readStringAttribute("danglingLineId1");
            String dl2Id = context.getReader().readStringAttribute("danglingLineId2");
            adder.setDanglingLine1(dl1Id).setDanglingLine2(dl2Id);
        });
        return adder.add();
    }

    private static DanglingLineAdder readVlAndNodeOrBus(NetworkDeserializerContext context, Network network, int side) {
        String voltageLevelId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("voltageLevelId" + side));
        DanglingLineAdder adderDl1 = network.getVoltageLevel(voltageLevelId).newDanglingLine();
        ConnectableSerDeUtil.readNodeOrBus(adderDl1, String.valueOf(side), context);
        return adderDl1;
    }

    @Override
    protected void readSubElements(TieLine tl, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tl.getDanglingLine1().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tl.getDanglingLine1().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    ConnectableSerDeUtil.readCurrentLimits(tl.getDanglingLine1().newCurrentLimits(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tl.getDanglingLine2().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tl.getDanglingLine2().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    ConnectableSerDeUtil.readCurrentLimits(tl.getDanglingLine2().newCurrentLimits(), context.getReader());
                    break;
                }
                default: {
                    this.readSubElement(elementName, tl, context);
                }
            }
        });
    }

    private static void checkBoundaryValue(double imported, double calculated, String name, String ucteXnodeCode) {
        if (!Double.isNaN(imported) && imported != calculated) {
            LOGGER.info("{} of the TieLine with ucteXnodeCode {} is recalculated. Its imported value is not used (imported value = {}; calculated value = {})", new Object[]{name, ucteXnodeCode, imported, calculated});
        }
    }
}

