/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.serde.AbstractTransformerSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Optional;

class TwoWindingsTransformerSerDe
extends AbstractTransformerSerDe<TwoWindingsTransformer, TwoWindingsTransformerAdder> {
    static final TwoWindingsTransformerSerDe INSTANCE = new TwoWindingsTransformerSerDe();
    static final String ROOT_ELEMENT_NAME = "twoWindingsTransformer";
    static final String ARRAY_ELEMENT_NAME = "twoWindingsTransformers";

    TwoWindingsTransformerSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(TwoWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("r", twt.getR());
        context.getWriter().writeDoubleAttribute("x", twt.getX());
        context.getWriter().writeDoubleAttribute("g", twt.getG());
        context.getWriter().writeDoubleAttribute("b", twt.getB());
        context.getWriter().writeDoubleAttribute("ratedU1", twt.getRatedU1());
        context.getWriter().writeDoubleAttribute("ratedU2", twt.getRatedU2());
        TwoWindingsTransformerSerDe.writeRatedS("ratedS", twt.getRatedS(), context);
        ConnectableSerDeUtil.writeNodeOrBus(1, twt.getTerminal1(), context);
        ConnectableSerDeUtil.writeNodeOrBus(2, twt.getTerminal2(), context);
        if (context.getOptions().isWithBranchSV()) {
            ConnectableSerDeUtil.writePQ(1, twt.getTerminal1(), context.getWriter());
            ConnectableSerDeUtil.writePQ(2, twt.getTerminal2(), context.getWriter());
        }
    }

    @Override
    protected void writeSubElements(TwoWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        Optional currentLimits2;
        Optional apparentPowerLimits2;
        Optional activePowerLimits2;
        Optional currentLimits1;
        Optional apparentPowerLimits1;
        Optional activePowerLimits1;
        PhaseTapChanger ptc;
        RatioTapChanger rtc = twt.getRatioTapChanger();
        if (rtc != null) {
            TwoWindingsTransformerSerDe.writeRatioTapChanger("ratioTapChanger", rtc, context);
        }
        if ((ptc = twt.getPhaseTapChanger()) != null) {
            TwoWindingsTransformerSerDe.writePhaseTapChanger("phaseTapChanger", ptc, context);
        }
        if ((activePowerLimits1 = twt.getActivePowerLimits1()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits1 = twt.getApparentPowerLimits1()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits1 = twt.getCurrentLimits1()).isPresent()) {
            ConnectableSerDeUtil.writeCurrentLimits((Integer)1, (CurrentLimits)currentLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
        if ((activePowerLimits2 = twt.getActivePowerLimits2()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits2 = twt.getApparentPowerLimits2()).isPresent()) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits2 = twt.getCurrentLimits2()).isPresent()) {
            ConnectableSerDeUtil.writeCurrentLimits((Integer)2, (CurrentLimits)currentLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
    }

    @Override
    protected TwoWindingsTransformerAdder createAdder(Substation s) {
        return s.newTwoWindingsTransformer();
    }

    @Override
    protected TwoWindingsTransformer readRootElementAttributes(TwoWindingsTransformerAdder adder, Substation s, NetworkDeserializerContext context) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g = context.getReader().readDoubleAttribute("g");
        double b = context.getReader().readDoubleAttribute("b");
        double ratedU1 = context.getReader().readDoubleAttribute("ratedU1");
        double ratedU2 = context.getReader().readDoubleAttribute("ratedU2");
        adder.setR(r).setX(x).setG(g).setB(b).setRatedU1(ratedU1).setRatedU2(ratedU2);
        TwoWindingsTransformerSerDe.readRatedS("ratedS", context, arg_0 -> ((TwoWindingsTransformerAdder)adder).setRatedS(arg_0));
        ConnectableSerDeUtil.readNodeOrBus(adder, context);
        TwoWindingsTransformer twt = adder.add();
        ConnectableSerDeUtil.readPQ(1, twt.getTerminal1(), context.getReader());
        ConnectableSerDeUtil.readPQ(2, twt.getTerminal2(), context.getReader());
        return twt;
    }

    @Override
    protected void readSubElements(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(twt.newActivePowerLimits1(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(twt.newApparentPowerLimits1(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    ConnectableSerDeUtil.readCurrentLimits(twt.newCurrentLimits1(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(twt.newActivePowerLimits2(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(twt.newApparentPowerLimits2(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    ConnectableSerDeUtil.readCurrentLimits(twt.newCurrentLimits2(), context.getReader());
                    break;
                }
                case "ratioTapChanger": {
                    TwoWindingsTransformerSerDe.readRatioTapChanger(twt, context);
                    break;
                }
                case "phaseTapChanger": {
                    TwoWindingsTransformerSerDe.readPhaseTapChanger(twt, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, twt, context);
                }
            }
        });
    }
}

