/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractVersionableNetworkExtensionSerDe<T extends Extendable, E extends Extension<T>>
implements ExtensionSerDe<T, E> {
    private static final String INCOMPATIBILITY_NETWORK_VERSION_MESSAGE = "IIDM version of network (";
    private final String extensionName;
    private final Class<? super E> extensionClass;
    private final String namespacePrefix;
    private final Map<IidmVersion, ImmutableSortedSet<String>> extensionVersions = new EnumMap<IidmVersion, ImmutableSortedSet<String>>(IidmVersion.class);
    private final BiMap<String, String> namespaceUris = HashBiMap.create();

    protected AbstractVersionableNetworkExtensionSerDe(String extensionName, Class<? super E> extensionClass, String namespacePrefix, Map<IidmVersion, ImmutableSortedSet<String>> extensionVersions, Map<String, String> namespaceUris) {
        this.extensionName = Objects.requireNonNull(extensionName);
        this.extensionClass = Objects.requireNonNull(extensionClass);
        this.namespacePrefix = Objects.requireNonNull(namespacePrefix);
        this.extensionVersions.putAll(Objects.requireNonNull(extensionVersions));
        this.namespaceUris.putAll(Objects.requireNonNull(namespaceUris));
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getCategoryName() {
        return "network";
    }

    public Class<? super E> getExtensionClass() {
        return this.extensionClass;
    }

    public String getNamespaceUri() {
        return this.getNamespaceUri(this.getVersion());
    }

    public String getNamespaceUri(String extensionVersion) {
        return Optional.ofNullable((String)this.namespaceUris.get((Object)extensionVersion)).orElseThrow(() -> new PowsyblException("Namespace URI null for " + this.getExtensionName() + " extension's version " + extensionVersion));
    }

    public String getVersion() {
        return this.getVersion(IidmSerDeConstants.CURRENT_IIDM_VERSION);
    }

    public boolean versionExists(IidmVersion networkVersion) {
        return this.extensionVersions.containsKey((Object)networkVersion);
    }

    public String getVersion(IidmVersion networkVersion) {
        return (String)this.extensionVersions.get((Object)networkVersion).last();
    }

    public String getVersion(String namespaceUri) {
        return Optional.ofNullable((String)this.namespaceUris.inverse().get((Object)namespaceUri)).orElseThrow(() -> new PowsyblException("The namespace URI " + namespaceUri + " of the " + this.extensionName + " extension is not supported."));
    }

    public Set<String> getVersions() {
        return this.namespaceUris.keySet();
    }

    protected void checkReadingCompatibility(NetworkDeserializerContext networkContext) {
        IidmVersion version = networkContext.getVersion();
        this.checkCompatibilityNetworkVersion(version);
        if (this.extensionVersions.get((Object)version).stream().noneMatch(v -> networkContext.containsExtensionVersion(this.getExtensionName(), (String)v))) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not compatible with the " + this.extensionName + " extension's namespace URI.");
        }
    }

    public boolean checkWritingCompatibility(String extensionVersion, IidmVersion version) {
        this.checkExtensionVersionSupported(extensionVersion);
        this.checkCompatibilityNetworkVersion(version);
        if (!this.extensionVersions.get((Object)version).contains((Object)extensionVersion)) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not compatible with " + this.extensionName + " version " + extensionVersion);
        }
        return true;
    }

    private void checkCompatibilityNetworkVersion(IidmVersion version) {
        if (!this.extensionVersions.containsKey((Object)version)) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not supported by the " + this.getExtensionName() + " extension's XML serializer.");
        }
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void checkExtensionVersionSupported(String extensionVersion) {
        if (!this.namespaceUris.containsKey((Object)extensionVersion)) {
            throw new PowsyblException("The " + this.extensionName + " extension version " + extensionVersion + " is not supported.");
        }
    }
}

