/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class ActivePowerControlSerDe<T extends Injection<T>>
extends AbstractVersionableNetworkExtensionSerDe<T, ActivePowerControl<T>> {
    public ActivePowerControlSerDe() {
        super("activePowerControl", ActivePowerControl.class, "apc", (Map<IidmVersion, ImmutableSortedSet<String>>)new ImmutableMap.Builder().put((Object)IidmVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).build(), (Map<String, String>)new ImmutableMap.Builder().put((Object)"1.0", (Object)"http://www.itesla_project.eu/schema/iidm/ext/active_power_control/1_0").put((Object)"1.1", (Object)"http://www.powsybl.org/schema/iidm/ext/active_power_control/1_1").build());
    }

    public void write(ActivePowerControl<T> activePowerControl, SerializerContext context) {
        context.getWriter().writeBooleanAttribute("participate", activePowerControl.isParticipate());
        context.getWriter().writeDoubleAttribute("droop", activePowerControl.getDroop());
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        String extVersionStr = networkContext.getExtensionVersion("position").orElseGet(() -> this.getVersion(networkContext.getVersion()));
        if ("1.1".compareTo(extVersionStr) <= 0) {
            context.getWriter().writeDoubleAttribute("participationFactor", activePowerControl.getParticipationFactor());
        }
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_1.xsd"), this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_0.xsd"));
    }

    public ActivePowerControl<T> read(T identifiable, DeserializerContext context) {
        boolean participate = context.getReader().readBooleanAttribute("participate");
        float droop = context.getReader().readFloatAttribute("droop");
        double participationFactor = Double.NaN;
        NetworkDeserializerContext networkContext = (NetworkDeserializerContext)context;
        String extVersionStr = networkContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new);
        if ("1.1".compareTo(extVersionStr) <= 0) {
            participationFactor = context.getReader().readDoubleAttribute("participationFactor");
        }
        context.getReader().readEndNode();
        ActivePowerControlAdder activePowerControlAdder = (ActivePowerControlAdder)identifiable.newExtension(ActivePowerControlAdder.class);
        return (ActivePowerControl)activePowerControlAdder.withParticipate(participate).withDroop((double)droop).withParticipationFactor(participationFactor).add();
    }
}

