/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoService(value={ExtensionSerDe.class})
public class ConnectablePositionSerDe<C extends Connectable<C>>
extends AbstractVersionableNetworkExtensionSerDe<C, ConnectablePosition<C>> {
    private static final String V_1_0 = "1.0";
    private static final String V_1_1 = "1.1";

    public ConnectablePositionSerDe() {
        super("position", ConnectablePosition.class, "cp", (Map<IidmVersion, ImmutableSortedSet<String>>)ImmutableMap.builder().put((Object)IidmVersion.V_1_0, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_1, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_2, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).build(), (Map<String, String>)ImmutableMap.builder().put((Object)V_1_0, (Object)"http://www.itesla_project.eu/schema/iidm/ext/connectable_position/1_0").put((Object)V_1_1, (Object)"http://www.powsybl.org/schema/iidm/ext/connectable_position/1_1").build());
    }

    private void writePosition(String connectableId, ConnectablePosition.Feeder feeder, Integer i, NetworkSerializerContext context) {
        String extVersionStr;
        context.getWriter().writeStartNode(context.getExtensionVersion("position").map(this::getNamespaceUri).orElseGet(this::getNamespaceUri), "feeder" + (Serializable)(i != null ? i : ""));
        switch (extVersionStr = context.getExtensionVersion("position").orElseGet(() -> this.getVersion(context.getVersion()))) {
            case "1.0": {
                context.getWriter().writeStringAttribute("name", feeder.getName().orElse(connectableId));
                break;
            }
            case "1.1": {
                feeder.getName().ifPresent(name -> context.getWriter().writeStringAttribute("name", name));
                break;
            }
            default: {
                throw new PowsyblException("Unsupported version (" + extVersionStr + ") for position");
            }
        }
        Optional oOrder = feeder.getOrder();
        oOrder.ifPresent(integer -> context.getWriter().writeIntAttribute("order", integer.intValue()));
        context.getWriter().writeStringAttribute("direction", feeder.getDirection().name());
        context.getWriter().writeEndNode();
    }

    public void write(ConnectablePosition<C> connectablePosition, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        String connectableId = ((Connectable)connectablePosition.getExtendable()).getId();
        if (connectablePosition.getFeeder() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder(), null, networkContext);
        }
        if (connectablePosition.getFeeder1() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder1(), 1, networkContext);
        }
        if (connectablePosition.getFeeder2() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder2(), 2, networkContext);
        }
        if (connectablePosition.getFeeder3() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder3(), 3, networkContext);
        }
    }

    private void readPosition(DeserializerContext context, ConnectablePositionAdder.FeederAdder<C> adder) {
        String name = context.getReader().readStringAttribute("name");
        Optional.ofNullable(context.getReader().readIntAttribute("order")).ifPresent(arg_0 -> adder.withOrder(arg_0));
        ConnectablePosition.Direction direction = (ConnectablePosition.Direction)context.getReader().readEnumAttribute("direction", ConnectablePosition.Direction.class);
        context.getReader().readEndNode();
        if (name != null) {
            adder.withName(name);
        } else {
            NetworkDeserializerContext networkSerializerReaderContext = (NetworkDeserializerContext)context;
            String extensionVersionStr = networkSerializerReaderContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new);
            if (V_1_1.compareTo(extensionVersionStr) > 0) {
                throw new PowsyblException("Feeder name is mandatory for version < 1.1");
            }
        }
        adder.withDirection(direction).add();
    }

    public ConnectablePosition<C> read(C connectable, DeserializerContext context) {
        ConnectablePositionAdder adder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "feeder": {
                    this.readPosition(context, adder.newFeeder());
                    break;
                }
                case "feeder1": {
                    this.readPosition(context, adder.newFeeder1());
                    break;
                }
                case "feeder2": {
                    this.readPosition(context, adder.newFeeder2());
                    break;
                }
                case "feeder3": {
                    this.readPosition(context, adder.newFeeder3());
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'position'");
                }
            }
        });
        return (ConnectablePosition)adder.add();
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_1.xsd"), this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_0.xsd"));
    }
}

