/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.GeneratorStartup;
import com.powsybl.iidm.network.extensions.GeneratorStartupAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class GeneratorStartupSerDe
extends AbstractVersionableNetworkExtensionSerDe<Generator, GeneratorStartup> {
    private static final String ITESLA_1_0 = "1.0-itesla";
    private static final String V_1_0 = "1.0";
    private static final String V_1_1 = "1.1";

    public GeneratorStartupSerDe() {
        super("startup", GeneratorStartup.class, "gs", (Map<IidmVersion, ImmutableSortedSet<String>>)ImmutableMap.builder().put((Object)IidmVersion.V_1_0, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_1, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_2, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).build(), (Map<String, String>)ImmutableMap.builder().put((Object)ITESLA_1_0, (Object)"http://www.itesla_project.eu/schema/iidm/ext/generator_startup/1_0").put((Object)V_1_0, (Object)"http://www.powsybl.org/schema/iidm/ext/generator_startup/1_0").put((Object)V_1_1, (Object)"http://www.powsybl.org/schema/iidm/ext/generator_startup/1_1").build());
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/generatorStartup_itesla_V1_0.xsd"), this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_0.xsd"), this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_1.xsd"));
    }

    public void write(GeneratorStartup startup, SerializerContext context) {
        String plannedActivePowerSetpoint;
        String extVersionStr;
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        String startupCost = switch (extVersionStr = networkContext.getExtensionVersion("startup").orElseGet(() -> this.getVersion(networkContext.getVersion()))) {
            case ITESLA_1_0, V_1_0 -> {
                plannedActivePowerSetpoint = "predefinedActivePowerSetpoint";
                yield "startUpCost";
            }
            case V_1_1 -> {
                plannedActivePowerSetpoint = "plannedActivePowerSetpoint";
                yield "startupCost";
            }
            default -> throw new PowsyblException("Unsupported startup version: " + extVersionStr);
        };
        context.getWriter().writeDoubleAttribute(plannedActivePowerSetpoint, startup.getPlannedActivePowerSetpoint());
        context.getWriter().writeDoubleAttribute(startupCost, startup.getStartupCost());
        context.getWriter().writeDoubleAttribute("marginalCost", startup.getMarginalCost());
        context.getWriter().writeDoubleAttribute("plannedOutageRate", startup.getPlannedOutageRate());
        context.getWriter().writeDoubleAttribute("forcedOutageRate", startup.getForcedOutageRate());
    }

    public GeneratorStartup read(Generator generator, DeserializerContext context) {
        double plannedActivePowerSetpoint;
        String extensionVersionStr;
        NetworkDeserializerContext networkSerializerReaderContext = (NetworkDeserializerContext)context;
        double startUpCost = switch (extensionVersionStr = networkSerializerReaderContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new)) {
            case ITESLA_1_0, V_1_0 -> {
                plannedActivePowerSetpoint = context.getReader().readDoubleAttribute("predefinedActivePowerSetpoint");
                yield context.getReader().readDoubleAttribute("startUpCost");
            }
            case V_1_1 -> {
                plannedActivePowerSetpoint = context.getReader().readDoubleAttribute("plannedActivePowerSetpoint");
                yield context.getReader().readDoubleAttribute("startupCost");
            }
            default -> throw new PowsyblException("Unsupported startup version: " + extensionVersionStr);
        };
        double marginalCost = context.getReader().readDoubleAttribute("marginalCost");
        double plannedOutageRate = context.getReader().readDoubleAttribute("plannedOutageRate");
        double forcedOutageRate = context.getReader().readDoubleAttribute("forcedOutageRate");
        context.getReader().readEndNode();
        return (GeneratorStartup)((GeneratorStartupAdder)generator.newExtension(GeneratorStartupAdder.class)).withPlannedActivePowerSetpoint(plannedActivePowerSetpoint).withStartupCost(startUpCost).withMarginalCost(marginalCost).withPlannedOutageRate(plannedOutageRate).withForcedOutageRate(forcedOutageRate).add();
    }
}

