/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControl;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControlAdder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableDouble;

@AutoService(value={ExtensionSerDe.class})
public class SecondaryVoltageControlSerDe
extends AbstractExtensionSerDe<Network, SecondaryVoltageControl> {
    private static final String CONTROL_ZONE_ROOT_ELEMENT = "controlZone";
    private static final String CONTROL_ZONE_ARRAY_ELEMENT = "controlZones";
    private static final String PILOT_POINT_ELEMENT = "pilotPoint";
    private static final String BUSBAR_SECTION_OR_BUS_ID_ROOT_ELEMENT = "busbarSectionOrBusId";
    private static final String BUSBAR_SECTION_OR_BUS_ID_ARRAY_ELEMENT = "busbarSectionOrBusIds";
    private static final String CONTROL_UNIT_ROOT_ELEMENT = "controlUnit";
    private static final String CONTROL_UNIT_ARRAY_ELEMENT = "controlUnits";

    public SecondaryVoltageControlSerDe() {
        super("secondaryVoltageControl", "network", SecondaryVoltageControl.class, "secondaryVoltageControl_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/secondary_voltage_control/1_0", "svc");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(CONTROL_ZONE_ARRAY_ELEMENT, CONTROL_ZONE_ROOT_ELEMENT, CONTROL_UNIT_ARRAY_ELEMENT, CONTROL_UNIT_ROOT_ELEMENT, BUSBAR_SECTION_OR_BUS_ID_ARRAY_ELEMENT, BUSBAR_SECTION_OR_BUS_ID_ROOT_ELEMENT);
    }

    public void write(SecondaryVoltageControl control, SerializerContext context) {
        TreeDataWriter writer = context.getWriter();
        writer.writeStartNodes();
        for (SecondaryVoltageControl.ControlZone controlZone : control.getControlZones()) {
            writer.writeStartNode(this.getNamespaceUri(), CONTROL_ZONE_ROOT_ELEMENT);
            writer.writeStringAttribute("name", controlZone.getName());
            this.writePilotPoint(controlZone, writer);
            this.writeControlUnits(controlZone.getControlUnits(), writer);
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    private void writePilotPoint(SecondaryVoltageControl.ControlZone controlZone, TreeDataWriter writer) {
        writer.writeStartNode(this.getNamespaceUri(), PILOT_POINT_ELEMENT);
        writer.writeDoubleAttribute("targetV", controlZone.getPilotPoint().getTargetV());
        writer.writeStartNodes();
        for (String busbarSectionOrBusId : controlZone.getPilotPoint().getBusbarSectionsOrBusesIds()) {
            writer.writeStartNode(this.getNamespaceUri(), BUSBAR_SECTION_OR_BUS_ID_ROOT_ELEMENT);
            writer.writeNodeContent(busbarSectionOrBusId);
            writer.writeEndNode();
        }
        writer.writeEndNodes();
        writer.writeEndNode();
    }

    private void writeControlUnits(List<SecondaryVoltageControl.ControlUnit> controlUnits, TreeDataWriter writer) {
        writer.writeStartNodes();
        for (SecondaryVoltageControl.ControlUnit controlUnit : controlUnits) {
            writer.writeStartNode(this.getNamespaceUri(), CONTROL_UNIT_ROOT_ELEMENT);
            writer.writeBooleanAttribute("participate", controlUnit.isParticipate());
            writer.writeNodeContent(controlUnit.getId());
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    public SecondaryVoltageControl read(Network network, DeserializerContext context) {
        SecondaryVoltageControlAdder adder = (SecondaryVoltageControlAdder)network.newExtension(SecondaryVoltageControlAdder.class);
        context.getReader().readChildNodes(elementName -> {
            if (!elementName.equals(CONTROL_ZONE_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'secondaryVoltageControl'");
            }
            SecondaryVoltageControlSerDe.readControlZone(context, adder);
        });
        return (SecondaryVoltageControl)adder.add();
    }

    private static void readControlZone(DeserializerContext context, SecondaryVoltageControlAdder adder) {
        String name = context.getReader().readStringAttribute("name");
        MutableDouble targetV = new MutableDouble(Double.NaN);
        ArrayList busbarSectionsOrBusesIds = new ArrayList();
        ArrayList controlUnits = new ArrayList();
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "pilotPoint": {
                    SecondaryVoltageControlSerDe.readPilotPoint(context, targetV, busbarSectionsOrBusesIds);
                    break;
                }
                case "controlUnit": {
                    SecondaryVoltageControlSerDe.readControlUnit(context, controlUnits);
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'controlZone'");
                }
            }
        });
        SecondaryVoltageControl.PilotPoint pilotPoint = new SecondaryVoltageControl.PilotPoint(busbarSectionsOrBusesIds, targetV.getValue().doubleValue());
        adder.addControlZone(new SecondaryVoltageControl.ControlZone(name, pilotPoint, controlUnits));
    }

    private static void readPilotPoint(DeserializerContext context, MutableDouble targetV, List<String> busbarSectionsOrBusesIds) {
        targetV.setValue(context.getReader().readDoubleAttribute("targetV"));
        context.getReader().readChildNodes(elementName -> {
            if (!elementName.equals(BUSBAR_SECTION_OR_BUS_ID_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'pilotPoint'");
            }
            busbarSectionsOrBusesIds.add(context.getReader().readContent());
        });
    }

    private static void readControlUnit(DeserializerContext context, List<SecondaryVoltageControl.ControlUnit> controlUnits) {
        boolean participate = context.getReader().readBooleanAttribute("participate");
        String id = context.getReader().readContent();
        controlUnits.add(new SecondaryVoltageControl.ControlUnit(id, participate));
    }
}

