/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.ReactiveLimitsSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class BatterySerDe
extends AbstractSimpleIdentifiableSerDe<Battery, BatteryAdder, VoltageLevel> {
    static final BatterySerDe INSTANCE = new BatterySerDe();
    static final String ROOT_ELEMENT_NAME = "battery";
    static final String ARRAY_ELEMENT_NAME = "batteries";

    BatterySerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Battery b, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute(IidmSerDeUtil.getAttributeName("p0", "targetP", context.getVersion(), IidmVersion.V_1_8), b.getTargetP());
        context.getWriter().writeDoubleAttribute(IidmSerDeUtil.getAttributeName("q0", "targetQ", context.getVersion(), IidmVersion.V_1_8), b.getTargetQ());
        context.getWriter().writeDoubleAttribute("minP", b.getMinP());
        context.getWriter().writeDoubleAttribute("maxP", b.getMaxP());
        ConnectableSerDeUtil.writeNodeOrBus(null, b.getTerminal(), context);
        ConnectableSerDeUtil.writePQ(null, b.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(Battery b, VoltageLevel vl, NetworkSerializerContext context) {
        ReactiveLimitsSerDe.INSTANCE.write((ReactiveLimitsHolder)b, context);
    }

    @Override
    protected BatteryAdder createAdder(VoltageLevel vl) {
        return vl.newBattery();
    }

    @Override
    protected Battery readRootElementAttributes(BatteryAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        double targetP = context.getReader().readDoubleAttribute(IidmSerDeUtil.getAttributeName("p0", "targetP", context.getVersion(), IidmVersion.V_1_8));
        double targetQ = context.getReader().readDoubleAttribute(IidmSerDeUtil.getAttributeName("q0", "targetQ", context.getVersion(), IidmVersion.V_1_8));
        double minP = context.getReader().readDoubleAttribute("minP");
        double maxP = context.getReader().readDoubleAttribute("maxP");
        ConnectableSerDeUtil.readNodeOrBus(adder, context, voltageLevel.getTopologyKind());
        Battery b = adder.setTargetP(targetP).setTargetQ(targetQ).setMinP(minP).setMaxP(maxP).add();
        ConnectableSerDeUtil.readPQ(null, b.getTerminal(), context.getReader());
        return b;
    }

    @Override
    protected void readSubElements(Battery b, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "reactiveCapabilityCurve": {
                    ReactiveLimitsSerDe.INSTANCE.readReactiveCapabilityCurve((ReactiveLimitsHolder)b, context);
                    break;
                }
                case "minMaxReactiveLimits": {
                    ReactiveLimitsSerDe.INSTANCE.readMinMaxReactiveLimits((ReactiveLimitsHolder)b, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, b, context);
                }
            }
        });
    }
}

