/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.OverloadManagementSystemSerDe;
import com.powsybl.iidm.serde.ThreeWindingsTransformerSerDe;
import com.powsybl.iidm.serde.TwoWindingsTransformerSerDe;
import com.powsybl.iidm.serde.VoltageLevelSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubstationSerDe
extends AbstractSimpleIdentifiableSerDe<Substation, SubstationAdder, Network> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubstationSerDe.class);
    static final SubstationSerDe INSTANCE = new SubstationSerDe();
    static final String ROOT_ELEMENT_NAME = "substation";
    static final String ARRAY_ELEMENT_NAME = "substations";
    private static final String COUNTRY = "country";

    SubstationSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Substation s, Network n, NetworkSerializerContext context) {
        context.getWriter().writeStringAttribute(COUNTRY, (String)s.getCountry().map(c -> context.getAnonymizer().anonymizeCountry((Country)c).toString()).orElse(null));
        context.getWriter().writeStringAttribute("tso", (String)Optional.ofNullable(s.getTso()).map(tso -> context.getAnonymizer().anonymizeString((String)tso)).orElse(null));
        context.getWriter().writeStringArrayAttribute("geographicalTags", s.getGeographicalTags().stream().map(tag -> context.getAnonymizer().anonymizeString((String)tag)).toList());
    }

    @Override
    protected void writeSubElements(Substation s, Network n, NetworkSerializerContext context) {
        SubstationSerDe.writeVoltageLevels(s, context);
        SubstationSerDe.writeTwoWindingsTransformers(s, context);
        SubstationSerDe.writeThreeWindingsTransformers(s, context);
        SubstationSerDe.writeOverloadManagementSystems(s, context);
    }

    private static void writeVoltageLevels(Substation s, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (VoltageLevel vl : IidmSerDeUtil.sorted(s.getVoltageLevels(), context.getOptions())) {
            VoltageLevelSerDe.INSTANCE.write(vl, null, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeTwoWindingsTransformers(Substation s, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        Iterable<TwoWindingsTransformer> twts = IidmSerDeUtil.sorted(s.getTwoWindingsTransformers(), context.getOptions());
        for (TwoWindingsTransformer twt : twts) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            TwoWindingsTransformerSerDe.INSTANCE.write(twt, null, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeThreeWindingsTransformers(Substation s, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        Iterable<ThreeWindingsTransformer> twts = IidmSerDeUtil.sorted(s.getThreeWindingsTransformers(), context.getOptions());
        for (ThreeWindingsTransformer twt : twts) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            ThreeWindingsTransformerSerDe.INSTANCE.write(twt, null, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeOverloadManagementSystems(Substation s, NetworkSerializerContext context) {
        if (!context.getOptions().isWithAutomationSystems()) {
            return;
        }
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            Collection<OverloadManagementSystem> validOverloadManagementSystems = SubstationSerDe.filterValidOverloadManagementSystems(s);
            if (!validOverloadManagementSystems.isEmpty()) {
                context.getWriter().writeStartNodes();
                IidmSerDeUtil.sorted(validOverloadManagementSystems, context.getOptions()).forEach(oms -> OverloadManagementSystemSerDe.INSTANCE.write(oms, null, context));
                context.getWriter().writeEndNodes();
            }
        });
    }

    private static Collection<OverloadManagementSystem> filterValidOverloadManagementSystems(Substation s) {
        Network n = s.getNetwork();
        return s.getOverloadManagementSystemStream().filter(o -> {
            if (n.getIdentifiable(o.getMonitoredElementId()) == null) {
                LOGGER.warn(String.format("Discard overload management system '%s': monitored element '%s' is unknown.", o.getNameOrId(), o.getMonitoredElementId()));
                return false;
            }
            for (OverloadManagementSystem.Tripping tripping : o.getTrippings()) {
                Branch element = null;
                String id = "";
                String type = "";
                switch (tripping.getType()) {
                    case BRANCH_TRIPPING: {
                        type = "branch";
                        id = ((OverloadManagementSystem.BranchTripping)tripping).getBranchToOperateId();
                        element = n.getBranch(id);
                        break;
                    }
                    case SWITCH_TRIPPING: {
                        type = "switch";
                        id = ((OverloadManagementSystem.SwitchTripping)tripping).getSwitchToOperateId();
                        element = n.getSwitch(id);
                        break;
                    }
                    case THREE_WINDINGS_TRANSFORMER_TRIPPING: {
                        type = "three windings transformer";
                        id = ((OverloadManagementSystem.ThreeWindingsTransformerTripping)tripping).getThreeWindingsTransformerToOperateId();
                        element = n.getThreeWindingsTransformer(id);
                    }
                }
                if (element != null) continue;
                LOGGER.warn(String.format("Discard overload management system '%s': invalid %s tripping. '%s' is unknown.", o.getNameOrId(), type, id));
                return false;
            }
            return true;
        }).toList();
    }

    @Override
    protected SubstationAdder createAdder(Network network) {
        return network.newSubstation();
    }

    @Override
    protected Substation readRootElementAttributes(SubstationAdder adder, Network network, NetworkDeserializerContext context) {
        Country country = Optional.ofNullable(context.getReader().readStringAttribute(COUNTRY)).map(c -> context.getAnonymizer().deanonymizeCountry(Country.valueOf((String)c))).orElse(null);
        String tso = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("tso"));
        String[] geographicalTags = (String[])context.getReader().readStringArrayAttribute("geographicalTags").stream().map(tag -> context.getAnonymizer().deanonymizeString((String)tag)).toArray(String[]::new);
        return adder.setCountry(country).setTso(tso).setGeographicalTags(geographicalTags).add();
    }

    @Override
    protected void readSubElements(Substation s, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "voltageLevel": {
                    VoltageLevelSerDe.INSTANCE.read(s, context);
                    break;
                }
                case "twoWindingsTransformer": {
                    TwoWindingsTransformerSerDe.INSTANCE.read(s, context);
                    break;
                }
                case "threeWindingsTransformer": {
                    ThreeWindingsTransformerSerDe.INSTANCE.read(s, context);
                    break;
                }
                case "overloadManagementSystem": {
                    SubstationSerDe.checkSupportedAndReadOverloadManagementSystems(s, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, s, context);
                }
            }
        });
    }

    private static void checkSupportedAndReadOverloadManagementSystems(Substation s, NetworkDeserializerContext context) {
        IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "overloadManagementSystem", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
        if (context.getOptions().isWithAutomationSystems()) {
            OverloadManagementSystemSerDe.INSTANCE.read(s, context);
        } else {
            OverloadManagementSystemSerDe.INSTANCE.skip(s, context);
        }
    }
}

