/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.ReactiveLimitsSerDe;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Objects;

class VscConverterStationSerDe
extends AbstractSimpleIdentifiableSerDe<VscConverterStation, VscConverterStationAdder, VoltageLevel> {
    static final VscConverterStationSerDe INSTANCE = new VscConverterStationSerDe();
    static final String ROOT_ELEMENT_NAME = "vscConverterStation";
    static final String ARRAY_ELEMENT_NAME = "vscConverterStations";
    private static final String REGULATING_TERMINAL = "regulatingTerminal";

    VscConverterStationSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(VscConverterStation cs, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeBooleanAttribute("voltageRegulatorOn", cs.isVoltageRegulatorOn());
        context.getWriter().writeFloatAttribute("lossFactor", cs.getLossFactor());
        context.getWriter().writeDoubleAttribute("voltageSetpoint", cs.getVoltageSetpoint());
        context.getWriter().writeDoubleAttribute("reactivePowerSetpoint", cs.getReactivePowerSetpoint());
        ConnectableSerDeUtil.writeNodeOrBus(null, cs.getTerminal(), context);
        ConnectableSerDeUtil.writePQ(null, cs.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(VscConverterStation cs, VoltageLevel vl, NetworkSerializerContext context) {
        ReactiveLimitsSerDe.INSTANCE.write((ReactiveLimitsHolder)cs, context);
        IidmSerDeUtil.assertMinimumVersionAndRunIfNotDefault(!Objects.equals(cs, cs.getRegulatingTerminal().getConnectable()), ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_6, context, () -> TerminalRefSerDe.writeTerminalRef(cs.getRegulatingTerminal(), context, REGULATING_TERMINAL));
    }

    @Override
    protected VscConverterStationAdder createAdder(VoltageLevel vl) {
        return vl.newVscConverterStation();
    }

    @Override
    protected VscConverterStation readRootElementAttributes(VscConverterStationAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        boolean voltageRegulatorOn = context.getReader().readBooleanAttribute("voltageRegulatorOn");
        float lossFactor = context.getReader().readFloatAttribute("lossFactor");
        double voltageSetpoint = context.getReader().readDoubleAttribute("voltageSetpoint");
        double reactivePowerSetpoint = context.getReader().readDoubleAttribute("reactivePowerSetpoint");
        ConnectableSerDeUtil.readNodeOrBus(adder, context, voltageLevel.getTopologyKind());
        ((VscConverterStationAdder)adder.setLossFactor(lossFactor)).setVoltageSetpoint(voltageSetpoint).setReactivePowerSetpoint(reactivePowerSetpoint).setVoltageRegulatorOn(voltageRegulatorOn);
        VscConverterStation cs = adder.add();
        ConnectableSerDeUtil.readPQ(null, cs.getTerminal(), context.getReader());
        return cs;
    }

    @Override
    protected void readSubElements(VscConverterStation cs, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "reactiveCapabilityCurve": {
                    ReactiveLimitsSerDe.INSTANCE.readReactiveCapabilityCurve((ReactiveLimitsHolder)cs, context);
                    break;
                }
                case "minMaxReactiveLimits": {
                    ReactiveLimitsSerDe.INSTANCE.readMinMaxReactiveLimits((ReactiveLimitsHolder)cs, context);
                    break;
                }
                case "regulatingTerminal": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_6, context);
                    TerminalRefSerDe.readTerminalRef(context, cs.getNetwork(), arg_0 -> ((VscConverterStation)cs).setRegulatingTerminal(arg_0));
                    break;
                }
                default: {
                    this.readSubElement(elementName, cs, context);
                }
            }
        });
    }
}

