/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.google.auto.service.AutoService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.serde.AbstractTreeDataImporter;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.IidmVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Importer.class})
public class XMLImporter
extends AbstractTreeDataImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLImporter.class);
    private static final String[] EXTENSIONS = new String[]{"xiidm", "iidm", "xml", "iidm.xml"};
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLInputFactory::newInstance);

    public XMLImporter() {
    }

    public XMLImporter(PlatformConfig platformConfig) {
        super(platformConfig);
    }

    @Override
    protected String[] getExtensions() {
        return EXTENSIONS;
    }

    public String getFormat() {
        return "XIIDM";
    }

    public String getComment() {
        return "IIDM XML v " + IidmSerDeConstants.CURRENT_IIDM_VERSION.toString(".") + " importer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        try {
            if (ext == null) return false;
            try (InputStream is = dataSource.newInputStream(null, ext);){
                XMLStreamReader xmlsr = ((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()).createXMLStreamReader(is);
                try {
                    int eventType;
                    do {
                        if (!xmlsr.hasNext()) return false;
                    } while ((eventType = xmlsr.next()) != 1);
                    String name = xmlsr.getLocalName();
                    String ns = xmlsr.getNamespaceURI();
                    boolean bl = "network".equals(name) && (Stream.of(IidmVersion.values()).anyMatch(v -> v.getNamespaceURI().equals(ns)) || Stream.of(IidmVersion.values()).filter(v -> v.compareTo(IidmVersion.V_1_7) >= 0).anyMatch(v -> v.getNamespaceURI(false).equals(ns)));
                    return bl;
                }
                finally {
                    try {
                        xmlsr.close();
                        XmlUtil.gcXmlInputFactory((XMLInputFactory)((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()));
                    }
                    catch (XMLStreamException e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            return false;
        }
    }
}

