/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.Coordinate;
import com.powsybl.iidm.network.extensions.LinePosition;
import com.powsybl.iidm.network.extensions.LinePositionAdder;
import java.util.ArrayList;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class LinePositionSerDe<T extends Identifiable<T>>
extends AbstractExtensionSerDe<T, LinePosition<T>> {
    private static final String COORDINATE_ROOT_NODE = "coordinate";
    private static final String COORDINATE_ARRAY_NODE = "coordinates";

    public LinePositionSerDe() {
        super("linePosition", "network", LinePosition.class, "linePosition.xsd", "http://www.powsybl.org/schema/iidm/ext/line_position/1_0", "lp");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(COORDINATE_ARRAY_NODE, COORDINATE_ROOT_NODE);
    }

    public void write(LinePosition<T> linePosition, SerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Coordinate point : linePosition.getCoordinates()) {
            context.getWriter().writeStartNode(this.getNamespaceUri(), COORDINATE_ROOT_NODE);
            context.getWriter().writeDoubleAttribute("longitude", point.getLongitude());
            context.getWriter().writeDoubleAttribute("latitude", point.getLatitude());
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
    }

    public LinePosition<T> read(T line, DeserializerContext context) {
        ArrayList coordinates = new ArrayList();
        context.getReader().readChildNodes(elementName -> {
            if (!elementName.equals(COORDINATE_ROOT_NODE)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'linePosition'");
            }
            double longitude = context.getReader().readDoubleAttribute("longitude");
            double latitude = context.getReader().readDoubleAttribute("latitude");
            context.getReader().readEndNode();
            coordinates.add(new Coordinate(latitude, longitude));
        });
        LinePositionAdder adder = (LinePositionAdder)line.newExtension(LinePositionAdder.class);
        return (LinePosition)adder.withCoordinates(coordinates).add();
    }
}

