/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.MeasurementAdder;
import com.powsybl.iidm.network.extensions.Measurements;
import com.powsybl.iidm.network.extensions.MeasurementsAdder;
import java.util.Map;

@AutoService(value={ExtensionSerDe.class})
public class MeasurementsSerDe<C extends Connectable<C>>
extends AbstractExtensionSerDe<C, Measurements<C>> {
    private static final String MEASUREMENT_ROOT_ELEMENT = "measurement";
    private static final String MEASUREMENT_ARRAY_ELEMENT = "measurements";
    private static final String VALUE = "value";
    public static final String PROPERTY_ROOT_ELEMENT = "property";
    private static final String PROPERTY_ARRAY_ELEMENT = "properties";

    public MeasurementsSerDe() {
        super(MEASUREMENT_ARRAY_ELEMENT, "network", Measurements.class, "measurements.xsd", "http://www.powsybl.org/schema/iidm/ext/measurements/1_0", "m");
    }

    public Map<String, String> getArrayNameToSingleNameMap() {
        return Map.of(MEASUREMENT_ARRAY_ELEMENT, MEASUREMENT_ROOT_ELEMENT, PROPERTY_ARRAY_ELEMENT, PROPERTY_ROOT_ELEMENT);
    }

    public void write(Measurements<C> extension, SerializerContext context) {
        TreeDataWriter writer = context.getWriter();
        writer.writeStartNodes();
        for (Measurement measurement : extension.getMeasurements()) {
            writer.writeStartNode(this.getNamespaceUri(), MEASUREMENT_ROOT_ELEMENT);
            writer.writeStringAttribute("id", measurement.getId());
            writer.writeEnumAttribute("type", (Enum)measurement.getType());
            writer.writeEnumAttribute("side", (Enum)measurement.getSide());
            writer.writeDoubleAttribute(VALUE, measurement.getValue());
            writer.writeDoubleAttribute("standardDeviation", measurement.getStandardDeviation());
            writer.writeBooleanAttribute("valid", measurement.isValid());
            this.writeProperties(measurement, writer);
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    private void writeProperties(Measurement measurement, TreeDataWriter writer) {
        writer.writeStartNodes();
        for (String name : measurement.getPropertyNames()) {
            writer.writeStartNode(this.getNamespaceUri(), PROPERTY_ROOT_ELEMENT);
            writer.writeStringAttribute("name", name);
            writer.writeStringAttribute(VALUE, measurement.getProperty(name));
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    public Measurements<C> read(C extendable, DeserializerContext context) {
        MeasurementsAdder measurementsAdder = (MeasurementsAdder)extendable.newExtension(MeasurementsAdder.class);
        Measurements measurements = (Measurements)measurementsAdder.add();
        TreeDataReader reader = context.getReader();
        reader.readChildNodes(elementName -> {
            MeasurementAdder adder = measurements.newMeasurement().setId(reader.readStringAttribute("id")).setType((Measurement.Type)reader.readEnumAttribute("type", Measurement.Type.class)).setSide((ThreeSides)reader.readEnumAttribute("side", ThreeSides.class)).setValue(reader.readDoubleAttribute(VALUE)).setStandardDeviation(reader.readDoubleAttribute("standardDeviation")).setValid(reader.readBooleanAttribute("valid", true));
            if (!elementName.equals(MEASUREMENT_ROOT_ELEMENT)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'measurements'");
            }
            reader.readChildNodes(subElementName -> {
                if (!subElementName.equals(PROPERTY_ROOT_ELEMENT)) {
                    throw new PowsyblException("Unexpected element: " + subElementName);
                }
                adder.putProperty(reader.readStringAttribute("name"), reader.readStringAttribute(VALUE));
                reader.readEndNode();
            });
            adder.add();
        });
        return measurements;
    }

    public boolean isSerializable(Measurements<C> extension) {
        return !extension.getMeasurements().isEmpty();
    }
}

