/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;

public class LccConverterStationSerDe
extends AbstractSimpleIdentifiableSerDe<LccConverterStation, LccConverterStationAdder, VoltageLevel> {
    static final LccConverterStationSerDe INSTANCE = new LccConverterStationSerDe();
    static final String ROOT_ELEMENT_NAME = "lccConverterStation";
    static final String ARRAY_ELEMENT_NAME = "lccConverterStations";

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(LccConverterStation cs, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeFloatAttribute("lossFactor", cs.getLossFactor());
        context.getWriter().writeFloatAttribute("powerFactor", cs.getPowerFactor());
        ConnectableSerDeUtil.writeNodeOrBus(null, cs.getTerminal(), context);
        ConnectableSerDeUtil.writePQ(null, cs.getTerminal(), context.getWriter());
    }

    @Override
    protected LccConverterStationAdder createAdder(VoltageLevel vl) {
        return vl.newLccConverterStation();
    }

    @Override
    protected LccConverterStation readRootElementAttributes(LccConverterStationAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        float lossFactor = context.getReader().readFloatAttribute("lossFactor");
        float powerFactor = context.getReader().readFloatAttribute("powerFactor");
        ConnectableSerDeUtil.readNodeOrBus(adder, context, voltageLevel.getTopologyKind());
        LccConverterStation cs = ((LccConverterStationAdder)adder.setLossFactor(lossFactor)).setPowerFactor(powerFactor).add();
        ConnectableSerDeUtil.readPQ(null, cs.getTerminal(), context.getReader());
        return cs;
    }

    @Override
    protected void readSubElements(LccConverterStation cs, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(e -> this.readSubElement(e, cs, context));
    }
}

